/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.mime.parse;

import com.mulesoft.connectors.as2.internal.codec.CodecInputStream;
import com.mulesoft.connectors.as2.internal.mime.MimeHeaders;
import com.mulesoft.connectors.as2.internal.mime.MimePart;
import com.mulesoft.connectors.as2.internal.mime.parse.MimeContentParser;
import com.mulesoft.connectors.as2.internal.mime.parse.MimeParserController;
import com.mulesoft.connectors.as2.internal.stream.InputStreamResource;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMimeContentParser
implements MimeContentParser<MimePart> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleMimeContentParser.class);

    @Override
    public boolean canParseContentType(String contentType) {
        return true;
    }

    @Override
    public boolean digestRequired() {
        return true;
    }

    @Override
    public MimePart parse(MimeHeaders mimeHeaders, InputStream is, MimeParserController mimeParserController) throws IOException {
        LOGGER.debug("Parsing simple MIME content");
        MimePart mimePart = new MimePart();
        mimePart.setHeaders(mimeHeaders);
        InputStream decodedStream = CodecInputStream.builder(is, true).withEncoding(mimeHeaders.getContentTransferEncoding()).build();
        InputStreamResource inputStreamResource = InputStreamResource.saveToResource(decodedStream);
        mimePart.setContent(inputStreamResource.asInputStream());
        LOGGER.debug("Finished parsing simple MIME content");
        return mimePart;
    }
}

