/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.crypto;

import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2PEMParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2PEMParser.class);
    private static final String TAG_CLOSE = "-----";
    private static final String BEGIN_TAG = "-----BEGIN ";
    private static final String END_TAG = "-----END ";
    private static final String CERTIFICATE = "CERTIFICATE";
    private static final String ENCRYPTED_PRIVATE_KEY = "ENCRYPTED PRIVATE KEY";
    private static final Pattern CERTIFICATE_PATTERN = Pattern.compile("(?<certificate>-----BEGIN CERTIFICATE-----[^ \t]*-----END CERTIFICATE-----)", 2);
    private static final Pattern ENCRYPTED_PRIVATE_KEY_PATTERN = Pattern.compile("(?<encryptedPrivateKey>-----BEGIN ENCRYPTED PRIVATE KEY-----[^ \t]*-----END ENCRYPTED PRIVATE KEY-----)", 2);
    private PublicKey publicKey;
    private Certificate certificate;
    private PrivateKey privateKey;
    private String password;
    private String pemContent;

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public AS2PEMParser withPemContent(String pemContent) {
        this.pemContent = pemContent;
        return this;
    }

    public AS2PEMParser withPassword(String password) {
        this.password = password;
        return this;
    }

    public AS2PEMParser build() {
        this.certificate = this.getCertificate(this.pemContent);
        this.publicKey = this.getPublicKeyFromPem(this.pemContent);
        if (this.password != null) {
            this.privateKey = this.getPrivateKeyFromPem(this.pemContent, this.password);
            LOGGER.info("A new Pem parse was created with an encrypted private key pair");
        } else {
            LOGGER.info("A new Pem parse was created with only a certificate and public key");
        }
        return this;
    }

    public Certificate getCertificate(String pemContent) {
        String pemCertificateBlock = this.findCertificateBlock(pemContent);
        if (pemCertificateBlock == null) {
            LOGGER.warn("Could not find the Certificate block in the provided pem file");
            return null;
        }
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X509");
            return factory.generateCertificate(new ByteArrayInputStream(pemCertificateBlock.getBytes()));
        }
        catch (CertificateException e) {
            throw new AS2ExtensionException("PEM parse failed to extract certificate from pem file", AS2ErrorType.CONFIGURATION, e);
        }
    }

    private PublicKey getPublicKeyFromPem(String pemContent) {
        Certificate certificate = this.getCertificate(pemContent);
        if (certificate == null) {
            return null;
        }
        return certificate.getPublicKey();
    }

    public PrivateKey getPrivateKeyFromPem(String pemContent, String password) {
        JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
        String encryptedPrivateKeyBlock = this.findEncryptedPrivateKeyBlock(pemContent);
        if (encryptedPrivateKeyBlock == null) {
            LOGGER.warn("Could not find the Encrypted Private Key block in the provided pem file");
            return null;
        }
        PEMParser pemParser = new PEMParser((Reader)new StringReader(encryptedPrivateKeyBlock));
        try {
            InputDecryptorProvider decryptorProvider = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(password.toCharArray());
            PKCS8EncryptedPrivateKeyInfo keyInfo = (PKCS8EncryptedPrivateKeyInfo)pemParser.readObject();
            PrivateKeyInfo privateKeyInfo = keyInfo.decryptPrivateKeyInfo(decryptorProvider);
            return jcaPEMKeyConverter.getPrivateKey(privateKeyInfo);
        }
        catch (IOException | OperatorCreationException | PKCSException e) {
            throw new AS2ExtensionException("PEM parse failed to extract encrypted private keyBlock from pem file", AS2ErrorType.CONFIGURATION, e);
        }
    }

    private String findCertificateBlock(String pemContent) {
        Matcher m = CERTIFICATE_PATTERN.matcher(pemContent);
        if (m.find()) {
            return m.group("certificate");
        }
        return null;
    }

    private String findEncryptedPrivateKeyBlock(String pemContent) {
        Matcher m = ENCRYPTED_PRIVATE_KEY_PATTERN.matcher(pemContent);
        if (m.find()) {
            return m.group("encryptedPrivateKey");
        }
        return null;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

