/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.builder;

import com.mulesoft.connector.as2.internal.enums.EncodingType;
import com.mulesoft.connector.as2.internal.mime.MimeHeaders;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import java.io.InputStream;
import java.util.Map;

public abstract class MimePartBuilder {
    static final String DEFAULT_DISPOSITION = "Attachment";
    static final String APPLICATION_PKCS_7_SIGNATURE = "application/pkcs7-signature";
    static final String MULTIPART_SIGNED = "multipart/signed";
    InputStream content;
    MimeHeaders headers = new MimeHeaders();

    public abstract MimePart build();

    public MimePartBuilder withContent(InputStream content) {
        this.content = content;
        return this;
    }

    public MimePartBuilder withContentTransferEncoding(EncodingType encoding) {
        if (encoding != null) {
            this.headers.setContentTransferEncoding(encoding);
        }
        return this;
    }

    public MimePartBuilder withContentType(String contentType) {
        if (contentType != null) {
            this.headers.setContentType(contentType);
        }
        return this;
    }

    public MimePartBuilder withContentDescription(String contentDescription) {
        if (contentDescription != null) {
            this.headers.setContentDescription(contentDescription);
        }
        return this;
    }

    public MimePartBuilder withFileName(String fileName) {
        if (fileName != null) {
            this.headers.setContentDisposition(String.format("%s; filename=%s", DEFAULT_DISPOSITION, fileName));
        }
        return this;
    }

    public MimePartBuilder withHeaders(Map<String, String> headers) {
        if (headers != null) {
            this.headers.putAll(headers);
        }
        return this;
    }
}

