/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.parse;

import com.mulesoft.connector.as2.internal.codec.CodecInputStream;
import com.mulesoft.connector.as2.internal.mime.MimeHeaders;
import com.mulesoft.connector.as2.internal.mime.PKCS7MimePart;
import com.mulesoft.connector.as2.internal.mime.parse.MimeContentParser;
import com.mulesoft.connector.as2.internal.mime.parse.MimeParserController;
import java.io.InputStream;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS7SignatureContentParser
implements MimeContentParser<PKCS7MimePart> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PKCS7SignatureContentParser.class);

    @Override
    public boolean canParseContentType(String contentType) {
        return contentType != null && contentType.toLowerCase().startsWith("application/pkcs7-signature");
    }

    @Override
    public boolean digestRequired() {
        return false;
    }

    @Override
    public PKCS7MimePart parse(MimeHeaders mimeHeaders, InputStream is, MimeParserController mimeParserController) {
        LOGGER.debug("Parsing PKCS7 Signature MIME part");
        PKCS7MimePart mimePart = new PKCS7MimePart();
        mimePart.setHeaders(mimeHeaders);
        mimePart.setPkcs7Bytes(IOUtils.toByteArray((InputStream)CodecInputStream.builder(is, true).withEncoding(mimeHeaders.getContentTransferEncoding()).build()));
        LOGGER.debug("Finished parsing PKCS7 Signature MIME part");
        return mimePart;
    }
}

