/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.parse;

import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.mime.MimeHeaders;
import com.mulesoft.connector.as2.internal.mime.parse.FIFOByteBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeHeaderDeserializer {
    private static final String TAB = "\t";
    private static final Logger LOGGER = LoggerFactory.getLogger(MimeHeaderDeserializer.class);
    private static final byte[] CRLF = "\r\n".getBytes();

    public MimeHeaders deserializeEntityHeaders(InputStream is) throws IOException {
        List<String> headerLines = this.readHeaderLines(is);
        return this.parseHeaderLines(headerLines);
    }

    MimeHeaders parseHeaderLines(List<String> headerLines) {
        MimeHeaders headerMap = new MimeHeaders();
        for (String line : headerLines) {
            String[] headerEntry = line.split(":");
            if (headerEntry.length < 2) {
                throw new AS2ExtensionException(String.format("Unable to parse headers; could not split line \"%s\"", line), AS2ErrorType.MIME_PARSE);
            }
            headerMap.put(headerEntry[0].trim(), headerEntry[1].trim());
        }
        return headerMap;
    }

    List<String> readHeaderLines(InputStream is) throws IOException {
        String line;
        ArrayList<String> headerLines = new ArrayList<String>();
        do {
            if ((line = this.readLine(is)).isEmpty()) continue;
            if (line.startsWith(TAB)) {
                int lastIndex = headerLines.size() - 1;
                String fullAppendedHeader = (String)headerLines.get(lastIndex) + line.trim();
                headerLines.set(lastIndex, fullAppendedHeader);
                continue;
            }
            headerLines.add(line);
        } while (!line.isEmpty());
        return headerLines;
    }

    public MimeHeaders fromHttpHeaders(Map<String, String> httpHeaders) {
        LOGGER.debug("Deserialising headers");
        MimeHeaders mimeHeaders = new MimeHeaders();
        if (httpHeaders != null) {
            if (LOGGER.isDebugEnabled()) {
                for (String key : httpHeaders.keySet()) {
                    LOGGER.debug("{}, {}", (Object)key, (Object)httpHeaders.get(key));
                }
            }
            mimeHeaders.putAll(httpHeaders);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Returning:");
                for (String key : mimeHeaders.keySet()) {
                    LOGGER.debug("{},{}", (Object)key, mimeHeaders.get(key));
                }
            }
        } else {
            LOGGER.debug("Null HTTP Headers");
        }
        return mimeHeaders;
    }

    String readLine(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder;
        block5: {
            int count;
            FIFOByteBuffer fifoByteBuffer;
            block4: {
                fifoByteBuffer = new FIFOByteBuffer(CRLF.length);
                count = fifoByteBuffer.fillFifoBuffer(inputStream);
                stringBuilder = new StringBuilder();
                if (count != fifoByteBuffer.size()) break block4;
                while (fifoByteBuffer.getBytes()[0] != CRLF[0] || fifoByteBuffer.getBytes()[1] != CRLF[1]) {
                    int nextByte = inputStream.read();
                    if (nextByte != -1) {
                        stringBuilder.append((char)fifoByteBuffer.pushPull(nextByte));
                        continue;
                    }
                    for (byte buffByte : fifoByteBuffer.getBytes()) {
                        stringBuilder.append((char)buffByte);
                    }
                    return stringBuilder.toString();
                }
                break block5;
            }
            if (count >= fifoByteBuffer.size()) break block5;
            for (int i = 0; i < count; ++i) {
                stringBuilder.append((char)fifoByteBuffer.getBytes()[i]);
            }
        }
        return stringBuilder.toString();
    }
}

