/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.codec;

import com.mulesoft.connector.as2.internal.codec.Encoding;
import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.stream.Buffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.HashMap;

public class QuotedPrintableEncoding
extends Encoding {
    private static final byte[] SOFT_CRLF = new byte[]{61, 13, 10};
    private static final byte[] ENCODED_CRLF = new byte[]{61, 48, 68, 61, 48, 65};
    private static final byte[] ENCODED_SPACE = new byte[]{61, 50, 48};
    private static final byte[] ENCODED_TAB = new byte[]{61, 48, 57};
    private static final int MIME_MAX_LINE_LENGTH = 76;
    private static final int ENCODED_CHARACTER_LENGTH = 3;
    private static final byte[] hex = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final HashMap<Byte, Byte> hexMap = new HashMap();

    @Override
    public byte[] encode(PushbackInputStream inputStream) throws IOException {
        Buffer buffer = new Buffer(76 + SOFT_CRLF.length);
        int nextByte = inputStream.read();
        block5: while (nextByte > -1 && buffer.available() <= 73) {
            switch (nextByte) {
                case 10: 
                case 13: {
                    if (buffer.available() > 76 - ENCODED_CRLF.length) {
                        buffer.load(SOFT_CRLF);
                        inputStream.unread(nextByte);
                        return buffer.readAll();
                    }
                    buffer.load(ENCODED_CRLF);
                    nextByte = inputStream.read();
                    if (nextByte != 10) continue block5;
                    nextByte = inputStream.read();
                    continue block5;
                }
                case 32: {
                    nextByte = inputStream.read();
                    if (nextByte == 13 || nextByte == 10) {
                        buffer.load(ENCODED_SPACE);
                        continue block5;
                    }
                    buffer.load((byte)32);
                    continue block5;
                }
                case 9: {
                    nextByte = inputStream.read();
                    if (nextByte == 13 || nextByte == 10) {
                        buffer.load(ENCODED_TAB);
                        continue block5;
                    }
                    buffer.load((byte)9);
                    continue block5;
                }
            }
            this.encode((byte)nextByte, buffer);
            nextByte = inputStream.read();
        }
        if (nextByte > -1) {
            buffer.load(SOFT_CRLF);
            inputStream.unread(nextByte);
        }
        return buffer.readAll();
    }

    @Override
    public byte[] decode(PushbackInputStream inputStream) throws IOException {
        Buffer buffer = new Buffer(76);
        int nextByte = inputStream.read();
        while (nextByte > -1 && buffer.available() < 76) {
            if (nextByte == 61) {
                byte first = this.readNonWhitespace(inputStream);
                byte second = (byte)inputStream.read();
                if (first == 10 || first == 13 && second != 10) {
                    inputStream.unread(second);
                }
                if (hexMap.containsKey(first) && hexMap.containsKey(second)) {
                    nextByte = (hexMap.get(first) << 4) + hexMap.get(second);
                    buffer.load((byte)nextByte);
                }
            } else {
                buffer.load((byte)nextByte);
            }
            nextByte = inputStream.read();
        }
        if (nextByte > -1) {
            inputStream.unread((byte)nextByte);
        }
        return buffer.readAll();
    }

    @Override
    public byte[] decode(String encoded) {
        PushbackInputStream in = new PushbackInputStream(new ByteArrayInputStream(encoded.getBytes()));
        byte[] result = new byte[]{};
        try {
            byte[] decoded = this.decode(in);
            while (decoded.length > 0) {
                result = this.concatenate(result, decoded);
                decoded = this.decode(in);
            }
        }
        catch (IOException e) {
            throw new AS2ExtensionException("An error was thrown decoding", AS2ErrorType.MIME_PARSE, e);
        }
        return result;
    }

    private byte[] concatenate(byte[] a, byte[] b) {
        byte[] rv = new byte[a.length + b.length];
        System.arraycopy(a, 0, rv, 0, a.length);
        System.arraycopy(b, 0, rv, a.length, b.length);
        return rv;
    }

    private void encode(byte nextByte, Buffer buffer) {
        if (nextByte >= 32 && nextByte < 127 && nextByte != 61) {
            buffer.load(nextByte);
        } else {
            buffer.load((byte)61);
            buffer.load(hex[nextByte >> 4]);
            buffer.load(hex[nextByte & 0xF]);
        }
    }

    private byte readNonWhitespace(InputStream inputStream) throws IOException {
        int i = inputStream.read();
        while (i == 32 || i == 9) {
            i = inputStream.read();
        }
        return (byte)i;
    }

    static {
        hexMap.put((byte)48, (byte)0);
        hexMap.put((byte)49, (byte)1);
        hexMap.put((byte)50, (byte)2);
        hexMap.put((byte)51, (byte)3);
        hexMap.put((byte)52, (byte)4);
        hexMap.put((byte)53, (byte)5);
        hexMap.put((byte)54, (byte)6);
        hexMap.put((byte)55, (byte)7);
        hexMap.put((byte)56, (byte)8);
        hexMap.put((byte)57, (byte)9);
        hexMap.put((byte)65, (byte)10);
        hexMap.put((byte)66, (byte)11);
        hexMap.put((byte)67, (byte)12);
        hexMap.put((byte)68, (byte)13);
        hexMap.put((byte)69, (byte)18);
        hexMap.put((byte)70, (byte)15);
        hexMap.put((byte)97, (byte)10);
        hexMap.put((byte)98, (byte)11);
        hexMap.put((byte)99, (byte)12);
        hexMap.put((byte)100, (byte)13);
        hexMap.put((byte)101, (byte)18);
        hexMap.put((byte)102, (byte)15);
    }
}

