/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.builder;

import com.mulesoft.connector.as2.internal.codec.CodecInputStream;
import com.mulesoft.connector.as2.internal.crypto.AS2Signature;
import com.mulesoft.connector.as2.internal.crypto.PKCS7SignatureBlockInputStream;
import com.mulesoft.connector.as2.internal.enums.EncodingType;
import com.mulesoft.connector.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.builder.MimePartBuilder;
import java.security.cert.Certificate;

public class SignatureMimePartBuilder
extends MimePartBuilder {
    private AS2Signature signature;
    private Certificate certificate;
    private HashAlgorithm algorithm;

    public SignatureMimePartBuilder withSignature(AS2Signature signature) {
        this.signature = signature;
        return this;
    }

    public SignatureMimePartBuilder withCertificate(Certificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public SignatureMimePartBuilder withAlgorithm(HashAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @Override
    public MimePart build() {
        MimePart mimePart = new MimePart();
        if (this.signature == null) {
            throw new AS2ExtensionException("SignatureMimePartBuilder.build() was called before being initialised with an AS2Signature!");
        }
        this.content = new PKCS7SignatureBlockInputStream().withCertificate(this.certificate).withSignature(this.signature).withHashAlgorithm(this.algorithm);
        mimePart.setContent(CodecInputStream.builder(this.content, false).withEncoding(EncodingType.BASE64).build());
        this.headers.setContentType("application/pkcs7-signature");
        this.headers.setContentTransferEncoding(EncodingType.BASE64);
        mimePart.setHeaders(this.headers);
        return mimePart;
    }
}

