/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.builder;

import com.mulesoft.connector.as2.internal.crypto.AS2Digest;
import com.mulesoft.connector.as2.internal.crypto.AS2Signature;
import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.MimePartInputStream;
import com.mulesoft.connector.as2.internal.mime.builder.MimeMultipartBuilder;
import com.mulesoft.connector.as2.internal.mime.builder.SignatureMimePartBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Vector;

public class SignedMimeMultipartBuilder
extends MimeMultipartBuilder {
    private AS2Digest as2Digest;
    private MimePart signaturePart;
    private PrivateKey privateKey;
    private Certificate selfCertificate;

    public SignedMimeMultipartBuilder withDigest(AS2Digest as2Digest) {
        this.as2Digest = as2Digest;
        return this;
    }

    public SignedMimeMultipartBuilder withPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public SignedMimeMultipartBuilder withSelfCertificate(Certificate certificate) {
        this.selfCertificate = certificate;
        return this;
    }

    @Override
    public MimePart build() {
        this.validateReadyToBuild();
        AS2Signature as2Signature = new AS2Signature().withPrivateKey(this.privateKey).withDigest(this.as2Digest);
        this.signaturePart = new SignatureMimePartBuilder().withSignature(as2Signature).withCertificate(this.selfCertificate).withAlgorithm(this.as2Digest.getAlgorithm()).build();
        this.mimeParts.add(this.signaturePart);
        this.headers.setContentType(String.format("%s; protocol=\"%s\"; micalg=%s", "multipart/signed", "application/pkcs7-signature", this.as2Digest.getAlgorithm().name()));
        return super.build();
    }

    @Override
    protected InputStream composeContent() {
        Vector<InputStream> allTheStreams = new Vector<InputStream>();
        allTheStreams.add(new ByteArrayInputStream(this.boundary.getBytes()));
        allTheStreams.add(this.as2Digest.getDigestingInputStream());
        allTheStreams.add(new ByteArrayInputStream(this.boundary.getBytes()));
        allTheStreams.add(new MimePartInputStream(this.signaturePart));
        allTheStreams.add(new ByteArrayInputStream(this.boundaryEnd.getBytes()));
        return new SequenceInputStream(allTheStreams.elements());
    }

    private void validateReadyToBuild() {
        if (this.mimeParts.size() != 1) {
            throw new AS2ExtensionException("SignedMimeMultipartBuilder must be initialised with 1 and only 1 MimePart to sign before building");
        }
        if (this.privateKey == null) {
            throw new AS2ExtensionException("SignedMimeMultipartBuilder must be initialised with a PrivateKey before building", AS2ErrorType.CONFIGURATION);
        }
        if (this.selfCertificate == null) {
            throw new AS2ExtensionException("SignedMimeMultipartBuilder must be initialised with a Certificate before building", AS2ErrorType.CONFIGURATION);
        }
        if (this.as2Digest == null) {
            throw new AS2ExtensionException("SignedMimeMultipartBuilder must be initialised with a Digest before building");
        }
    }
}

