/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.parse;

import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.mime.MimeHeaders;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.parse.MimeBoundaryAwareInputStream;
import com.mulesoft.connector.as2.internal.mime.parse.MimeContentParser;
import com.mulesoft.connector.as2.internal.mime.parse.MimeParserController;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeMultipartContentParser
implements MimeContentParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimeMultipartContentParser.class);
    private static final String CRLF = "\r\n";
    private static final String BOUNDARY_PREFIX = "\r\n--";
    private static final String BOUNDARY_SUFFIX = "--\r\n";
    private static final Pattern BOUNDARY_PATTERN = Pattern.compile("boundary=\"?(?<boundaryId>[^; \t\r\n\"]*)", 2);

    @Override
    public boolean canParseContentType(String contentType) {
        return contentType != null && contentType.toLowerCase().startsWith("multipart/");
    }

    @Override
    public boolean digestRequired() {
        return false;
    }

    public MimePart parse(MimeHeaders mimeHeaders, InputStream is, MimeParserController mimeParserController) throws IOException {
        MimeBoundaryAwareInputStream inputStream;
        LOGGER.debug("Parsing MIME Multipart");
        MimePart mimePart = new MimePart();
        mimePart.setHeaders(mimeHeaders);
        String boundaryIdentifier = this.getBoundaryIdentifierFromHeaders(mimeHeaders);
        mimePart.setBoundaryIdentifier(boundaryIdentifier);
        int boundaryEndPaddedLength = (BOUNDARY_PREFIX + boundaryIdentifier + BOUNDARY_SUFFIX).length();
        PushbackInputStream pushbackInputStream = new PushbackInputStream(is, boundaryEndPaddedLength);
        do {
            inputStream = new MimeBoundaryAwareInputStream(pushbackInputStream, boundaryIdentifier);
            MimePart childMimePart = mimeParserController.parse(inputStream);
            childMimePart.setBoundaryIdentifier(boundaryIdentifier);
            mimePart.addMimePart(childMimePart);
        } while (inputStream.hasMoreParts());
        LOGGER.debug("Finished parsing MIME Multipart");
        return mimePart;
    }

    private String getBoundaryIdentifierFromHeaders(MimeHeaders mimeHeaders) {
        Matcher m = BOUNDARY_PATTERN.matcher(mimeHeaders.getContentType());
        if (m.find()) {
            return m.group("boundaryId");
        }
        throw new AS2ExtensionException(String.format("Could not read the boundary identifier in content type %s", mimeHeaders.getContentType()), AS2ErrorType.MIME_PARSE);
    }
}

