/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime;

import com.mulesoft.connector.as2.internal.enums.EncodingType;
import java.util.Map;
import org.mule.runtime.api.util.CaseInsensitiveMapWrapper;
import org.mule.runtime.api.util.MultiMap;

public class MimeHeaders
extends CaseInsensitiveMapWrapper<String> {
    static final String CONTENT_TYPE = "Content-Type";
    static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    static final String CONTENT_ID = "Content-ID";
    static final String CONTENT_DESCRIPTION = "Content-Description";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";

    public void setContentType(String contentType) {
        if (contentType != null) {
            this.put(CONTENT_TYPE, contentType);
        }
    }

    public String getContentType() {
        return (String)this.get(CONTENT_TYPE);
    }

    public void setContentTransferEncoding(EncodingType contentTransferEncoding) {
        if (contentTransferEncoding != null) {
            this.put(CONTENT_TRANSFER_ENCODING, contentTransferEncoding.getCanonicalName());
        }
    }

    public EncodingType getContentTransferEncoding() {
        return EncodingType.findByCanonicalName((String)this.get(CONTENT_TRANSFER_ENCODING));
    }

    public void setContentId(String contentId) {
        if (contentId != null) {
            this.put(CONTENT_ID, contentId);
        }
    }

    public String getContentId() {
        return (String)this.get(CONTENT_ID);
    }

    public void setContentDescription(String contentDescription) {
        if (contentDescription != null) {
            this.put(CONTENT_DESCRIPTION, contentDescription);
        }
    }

    public String getContentDescription() {
        return (String)this.get(CONTENT_DESCRIPTION);
    }

    public void setContentDisposition(String contentDisposition) {
        if (contentDisposition != null) {
            this.put(CONTENT_DISPOSITION, contentDisposition);
        }
    }

    public String getContentDisposition() {
        return (String)this.get(CONTENT_DISPOSITION);
    }

    public Map<String, String> getExtensionHeaders() {
        MultiMap extensionHeaders = new MultiMap();
        for (Map.Entry entry : this.entrySet()) {
            if (!this.isMimeExtensionHeader((String)entry.getKey())) continue;
            extensionHeaders.put(entry.getKey(), entry.getValue());
        }
        return extensionHeaders.toImmutableMultiMap();
    }

    public String put(String key, String value) {
        return (String)super.put(key, (Object)value);
    }

    public void putAll(Map<? extends String, ? extends String> m) {
        for (Map.Entry<? extends String, ? extends String> entry : m.entrySet()) {
            String key = entry.getKey();
            super.put(key, (Object)entry.getValue());
        }
    }

    private boolean isMimeExtensionHeader(String headerName) {
        return !CONTENT_TYPE.equalsIgnoreCase(headerName) && !CONTENT_TRANSFER_ENCODING.equalsIgnoreCase(headerName) && !CONTENT_ID.equalsIgnoreCase(headerName) && !CONTENT_DESCRIPTION.equalsIgnoreCase(headerName);
    }
}

