/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.builder;

import com.mulesoft.connector.as2.internal.enums.AS2Compression;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.MimePartInputStream;
import com.mulesoft.connector.as2.internal.mime.builder.MimePartBuilder;
import com.mulesoft.connector.as2.internal.stream.OutputTransformationInputStream;
import java.io.IOException;
import org.bouncycastle.cms.CMSCompressedDataStreamGenerator;
import org.bouncycastle.cms.jcajce.ZlibCompressor;
import org.bouncycastle.operator.OutputCompressor;

public class CompressedMimePartBuilder
extends MimePartBuilder {
    private static final String PKCS7_COMPRESSED_DATA = "application/pkcs7-mime; name=\"smime.p7z\"; smime-type=compressed-data";
    private static final String ATTACHMENT_SMIME_P7Z = "attachment; filename=\"smime.p7z\"";
    private static final String SMIME_COMPRESSED_MESSAGE = "S/MIME Compressed Message";
    private static final String NOT_ABLE_TO_COMPRESS_MIME_PART = "not able to compress mimepart";
    private AS2Compression as2Compression;
    private MimePart mimePart;

    public CompressedMimePartBuilder withAS2CompressionAlg(AS2Compression as2Compression) {
        this.as2Compression = as2Compression;
        return this;
    }

    public CompressedMimePartBuilder withMimePart(MimePart mimePart) {
        this.mimePart = mimePart;
        return this;
    }

    @Override
    public MimePart build() {
        OutputTransformationInputStream inputStream;
        MimePart compressedMimePart = new MimePart();
        this.headers.setContentType(PKCS7_COMPRESSED_DATA);
        this.headers.setContentDisposition(ATTACHMENT_SMIME_P7Z);
        this.headers.setContentDescription(SMIME_COMPRESSED_MESSAGE);
        compressedMimePart.setHeaders(this.headers);
        MimePartInputStream mimePartInputStream = new MimePartInputStream(this.mimePart);
        CMSCompressedDataStreamGenerator gen = new CMSCompressedDataStreamGenerator();
        try {
            inputStream = new OutputTransformationInputStream(mimePartInputStream, outputStream -> gen.open(outputStream, (OutputCompressor)new ZlibCompressor()));
        }
        catch (IOException e) {
            throw new AS2ExtensionException(NOT_ABLE_TO_COMPRESS_MIME_PART);
        }
        compressedMimePart.setContent(inputStream);
        return compressedMimePart;
    }
}

