/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.validate;

import com.mulesoft.connector.as2.internal.crypto.SignedMessageVerifier;
import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.DispositionType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.mime.SignedMimeMultipart;
import com.mulesoft.connector.as2.internal.mime.validate.MimePartValidator;
import java.security.PublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedMimeMultipartValidator
implements MimePartValidator<SignedMimeMultipart> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignedMimeMultipartValidator.class);
    private SignedMessageVerifier verifier;

    public SignedMimeMultipartValidator withPublicKey(PublicKey publicKey) {
        this.verifier = new SignedMessageVerifier(publicKey);
        return this;
    }

    SignedMimeMultipartValidator withSignedMessageVerifier(SignedMessageVerifier verifier) {
        this.verifier = verifier;
        return this;
    }

    @Override
    public boolean canValidate(String contentType) {
        return contentType != null && contentType.toLowerCase().startsWith("multipart/signed");
    }

    @Override
    public void validate(SignedMimeMultipart mimePart) {
        LOGGER.info("Validating signature of signed MIME multipart.");
        try {
            if (!this.verifier.validateSignature(mimePart.getPKCS7Signature(), mimePart.getContentDigest())) {
                throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_AUTHENTICATION_FAILED, "Signature of signed MIME message failed validation", AS2ErrorType.SIGNATURE_VERIFY);
            }
        }
        catch (AS2ExtensionException e) {
            if (e.getDisposition() == DispositionType.PROCESSED_ERROR_AUTHENTICATION_FAILED || e.getDisposition() == DispositionType.PROCESSED_ERROR_INTEGRITY_CHECK_FAILED) {
                throw e;
            }
            throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_AUTHENTICATION_FAILED, e.getMessage(), AS2ErrorType.SIGNATURE_VERIFY, (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_AUTHENTICATION_FAILED, e.getMessage(), AS2ErrorType.SIGNATURE_VERIFY, e);
        }
    }
}

