/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.receive;

import com.mulesoft.connector.as2.internal.crypto.AS2Digest;
import com.mulesoft.connector.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.DispositionType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.mime.MimeHeaders;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.MimePartFinder;
import com.mulesoft.connector.as2.internal.mime.MimePartInputStream;
import com.mulesoft.connector.as2.internal.mime.SignedMimeMultipart;
import com.mulesoft.connector.as2.internal.mime.builder.AS2MessageIdGeneratorFactory;
import com.mulesoft.connector.as2.internal.mime.builder.BoundaryIdentifierGeneratorFactory;
import com.mulesoft.connector.as2.internal.mime.builder.MDNReportMultiPartBuilder;
import com.mulesoft.connector.as2.internal.mime.builder.SignedMimeMultipartBuilder;
import com.mulesoft.connector.as2.internal.mime.parse.EncryptedMimeParser;
import com.mulesoft.connector.as2.internal.mime.parse.MimeParserController;
import com.mulesoft.connector.as2.internal.mime.validate.MimeValidatorController;
import com.mulesoft.connector.as2.internal.mime.validate.SignedMimeMultipartValidator;
import com.mulesoft.connector.as2.internal.receive.AbstractReceiveAttributesBuilder;
import com.mulesoft.connector.as2.internal.receive.DispositionNotificationParser;
import com.mulesoft.connector.as2.internal.receive.ReceiveHandlerCallback;
import com.mulesoft.connector.as2.internal.receive.ReceivedMessageInfo;
import com.mulesoft.connector.as2.internal.receive.RequestKeyStore;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceiveHandler.class);
    private static final Pattern CONTENT_DISPOSITION = Pattern.compile("filename=[\"]?(?<fileName>[^\"]*)[\"]?", 2);
    private BoundaryIdentifierGeneratorFactory boundaryIdentifierGeneratorFactory = new BoundaryIdentifierGeneratorFactory();
    private AS2MessageIdGeneratorFactory as2MessageIdGeneratorFactory = new AS2MessageIdGeneratorFactory();

    public ReceiveHandler withBoundaryIdentifierGeneratorFactory(BoundaryIdentifierGeneratorFactory boundaryIdentifierGeneratorFactory) {
        this.boundaryIdentifierGeneratorFactory = boundaryIdentifierGeneratorFactory;
        return this;
    }

    public ReceiveHandler withAS2MessageIdGeneratorFactory(AS2MessageIdGeneratorFactory as2MessageIdGeneratorFactory) {
        this.as2MessageIdGeneratorFactory = as2MessageIdGeneratorFactory;
        return this;
    }

    public void receiveAS2Message(CaseInsensitiveMultiMap httpHeaders, InputStream content, AbstractReceiveAttributesBuilder attributesBuilder, RequestKeyStore requestKeyStore, ReceiveHandlerCallback callback) {
        ReceivedMessageInfo messageInfo = new ReceivedMessageInfo();
        messageInfo.setContent(content);
        messageInfo.setHttpHeaders(httpHeaders);
        this.receiveAS2Message(messageInfo, attributesBuilder, requestKeyStore, callback);
    }

    private void receiveAS2Message(ReceivedMessageInfo messageInfo, AbstractReceiveAttributesBuilder attributesBuilder, RequestKeyStore requestKeyStore, ReceiveHandlerCallback callback) {
        try {
            messageInfo.setMdnSigningAlgorithm(this.getSigningAlgorithm(messageInfo));
            this.loadReceiveAttributesBuilder(attributesBuilder, (Map<String, String>)messageInfo.getHttpHeaders());
            MimePart receivedMimePart = this.parseReceivedMessage((Map<String, String>)messageInfo.getHttpHeaders(), messageInfo.getContent(), requestKeyStore.getSelfPrivateKey());
            if (this.receivedMultipartSignedMessage(receivedMimePart)) {
                PublicKey partnerPublicKey = requestKeyStore.getPartnerPublicKey();
                if (partnerPublicKey == null) {
                    LOGGER.error("Expected to be provided a Partners Public key to validate an incoming signed message!");
                } else {
                    this.processedSignedMessage(messageInfo, attributesBuilder, partnerPublicKey, receivedMimePart);
                }
            } else {
                this.processUnsignedMessage(messageInfo, attributesBuilder, receivedMimePart);
            }
            if (this.isMdnRequired((MultiMap<String, String>)messageInfo.getHttpHeaders())) {
                this.notifyResult(requestKeyStore, callback, messageInfo, DispositionType.PROCESSED, true);
            } else {
                callback.notifyResult(messageInfo.getContent(), null, null, null, true);
            }
        }
        catch (AS2ExtensionException exception) {
            LOGGER.debug("Error handling request. Attempting to generate response error mdn.", (Throwable)((Object)exception));
            this.doErrorMdnResponse(requestKeyStore, callback, messageInfo, exception.getDisposition());
        }
        catch (Throwable e) {
            LOGGER.error(e.getMessage(), e);
            this.closeContentStream(messageInfo);
            callback.notifyError(e);
        }
    }

    private void closeContentStream(ReceivedMessageInfo messageInfo) {
        if (messageInfo.getContent() != null) {
            try {
                messageInfo.getContent().close();
            }
            catch (IOException ioe) {
                LOGGER.warn("Error closing message input stream", (Throwable)ioe);
            }
            messageInfo.setContent(null);
        }
    }

    private HashAlgorithm getSigningAlgorithm(ReceivedMessageInfo messageInfo) {
        return HashAlgorithm.findByAlgorithm(this.getMdnSigningAlgorithm((Map<String, String>)messageInfo.getHttpHeaders()).algorithm());
    }

    private void processUnsignedMessage(ReceivedMessageInfo messageInfo, AbstractReceiveAttributesBuilder attributesBuilder, MimePart receivedMimePart) {
        Object digestMimePart = new MimePartFinder(mimePart -> mimePart.hasDigest()).find(receivedMimePart);
        if (digestMimePart != null) {
            messageInfo.setAs2Digest(((MimePart)digestMimePart).getAs2Digest());
        }
        messageInfo.setFileName(this.findFileName(receivedMimePart.getHeaders()));
        String contentType = receivedMimePart.getHeaders().getContentType();
        attributesBuilder.withFileName(messageInfo.getFileName()).withMimeType(contentType);
        messageInfo.setContent(receivedMimePart.getContent());
    }

    private void processedSignedMessage(ReceivedMessageInfo messageInfo, AbstractReceiveAttributesBuilder attributesBuilder, PublicKey partnerPublicKey, MimePart receivedMimePart) {
        this.validateReceivedMessageSignature(receivedMimePart, partnerPublicKey);
        SignedMimeMultipart receivedSignedMimeMultipart = (SignedMimeMultipart)receivedMimePart;
        messageInfo.setAs2Digest(receivedSignedMimeMultipart.getContentDigest());
        MimePart contentMimePart = receivedMimePart.getMimeParts().get(0);
        messageInfo.setFileName(this.findFileName(contentMimePart.getHeaders()));
        attributesBuilder.withFileName(messageInfo.getFileName()).withMimeType(contentMimePart.getHeaders().getContentType());
        messageInfo.setContent(contentMimePart.getContent());
    }

    String findFileName(MimeHeaders mimeContentPartHeaders) {
        String fileName = null;
        if (mimeContentPartHeaders.containsKey("Content-Disposition")) {
            String contentDisposition = mimeContentPartHeaders.getContentDisposition();
            fileName = this.findFileName(contentDisposition);
        }
        return fileName;
    }

    private void doErrorMdnResponse(RequestKeyStore requestKeyStore, ReceiveHandlerCallback callback, ReceivedMessageInfo messageInfo, DispositionType errorDisposition) {
        this.closeContentStream(messageInfo);
        if (this.isMdnRequired((MultiMap<String, String>)messageInfo.getHttpHeaders())) {
            DispositionType dispositionType = errorDisposition;
            if (errorDisposition == null) {
                dispositionType = DispositionType.PROCESSED_ERROR_UNEXPECTED_PROCESSING_ERROR;
            }
            this.notifyResult(requestKeyStore, callback, messageInfo, dispositionType, false);
        }
    }

    private void notifyResult(RequestKeyStore requestKeyStore, ReceiveHandlerCallback callback, ReceivedMessageInfo messageInfo, DispositionType dispositionType, boolean processed) {
        MimePart multipartReport = this.buildMdn(requestKeyStore, messageInfo, dispositionType);
        MultiMap<String, String> mdnHeaders = this.generateMDNHeaders(messageInfo.getHttpHeaders(), multipartReport);
        callback.notifyResult(messageInfo.getContent(), mdnHeaders, multipartReport.getContent(), dispositionType, processed);
    }

    private boolean receivedMultipartSignedMessage(MimePart receivedMimePart) {
        return ((String)receivedMimePart.getHeaders().get("Content-Type")).startsWith("multipart/signed");
    }

    private HashAlgorithm getMdnSigningAlgorithm(Map<String, String> httpHeaders) {
        DispositionNotificationParser parser = new DispositionNotificationParser(httpHeaders);
        return parser.signedReceiptMicAlg();
    }

    private MimePart buildMdn(RequestKeyStore requestKeyStore, ReceivedMessageInfo messageInfo, DispositionType dispositionType) {
        if (messageInfo.getAs2Digest() == null) {
            return this.buildMdnMimePart(requestKeyStore, messageInfo, null, dispositionType);
        }
        byte[] digestHash = messageInfo.getAs2Digest().getHash();
        return this.buildMdnMimePart(requestKeyStore, messageInfo, digestHash, dispositionType);
    }

    MimePart parseReceivedMessage(Map<String, String> httpHeaders, InputStream receivedMessage, PrivateKey privateKey) {
        MimeParserController mimeParserController = new MimeParserController();
        EncryptedMimeParser encryptedMimeParser = new EncryptedMimeParser();
        if (encryptedMimeParser.canParseContentType(httpHeaders.get("Content-Type"))) {
            if (privateKey == null) {
                LOGGER.error("Received message requiring decryption, but private key was null, please provide a valid private key.");
            }
            encryptedMimeParser.withPrivateKey(privateKey);
            mimeParserController.withContentParser(encryptedMimeParser);
        }
        try {
            return mimeParserController.parse(httpHeaders, receivedMessage);
        }
        catch (IOException e) {
            throw new AS2ExtensionException("Error parsing the received Content Stream", AS2ErrorType.MIME_PARSE, e);
        }
    }

    void validateReceivedMessageSignature(MimePart receivedMimePart, PublicKey storePublicKey) {
        SignedMimeMultipartValidator signedMimeMultipartValidator = new SignedMimeMultipartValidator().withPublicKey(storePublicKey);
        MimeValidatorController validatorController = new MimeValidatorController().withValidator(signedMimeMultipartValidator);
        validatorController.validate(receivedMimePart);
    }

    MultiMap<String, String> generateMDNHeaders(CaseInsensitiveMultiMap httpHeaders, MimePart mdnReportMultiPart) {
        MultiMap<String, String> mdnHeaders = new MultiMap<String, String>();
        mdnReportMultiPart.getHeaders().forEach((arg_0, arg_1) -> ((MultiMap)mdnHeaders).put(arg_0, arg_1));
        mdnHeaders = this.getCommonAS2HttpHeaders(mdnHeaders, (String)httpHeaders.get((Object)"AS2-From"), (String)httpHeaders.get((Object)"AS2-To"));
        mdnHeaders.put((Object)"Subject", (Object)String.format("Message Received MDN Response for ID %s", mdnHeaders.get((Object)"Message-ID")));
        if (this.isAsyncMdnRequested(httpHeaders)) {
            String deliveryAddress = (String)httpHeaders.get((Object)"Receipt-Delivery-Option");
            if (deliveryAddress.toLowerCase().startsWith("http")) {
                mdnHeaders.put((Object)"Recipient-Address", (Object)deliveryAddress);
                LOGGER.info(String.format("The Async MDN recipient address is %s", deliveryAddress));
            } else {
                String errorMessage = "The Recipient-Address %s obtained from Receipt-Delivery-Option was invalid as it did not start with http";
                throw new AS2ExtensionException(String.format(errorMessage, deliveryAddress), AS2ErrorType.MIME_PARSE);
            }
        }
        return mdnHeaders;
    }

    MimePart buildMdnMimePart(RequestKeyStore requestKeyStore, ReceivedMessageInfo messageInfo, byte[] originalMsgAS2DigestHash, DispositionType dispositionType) {
        String recipient = (String)messageInfo.getHttpHeaders().get((Object)"AS2-To");
        HashAlgorithm originalMicAlg = null;
        if (messageInfo.getAs2Digest() != null) {
            originalMicAlg = messageInfo.getAs2Digest().getAlgorithm();
        }
        MimePart multipartReport = new MDNReportMultiPartBuilder().withFileName(messageInfo.getFileName()).withMessageId((String)messageInfo.getHttpHeaders().get((Object)"Message-ID")).withFromPartnerName((String)messageInfo.getHttpHeaders().get((Object)"AS2-From")).withOriginalRecipient(recipient).withFinalRecipient(recipient).withReceiveDate(ZonedDateTime.now()).withDispositionType(dispositionType).withOriginalMic(originalMsgAS2DigestHash).withOriginalMicAlg(originalMicAlg).withBoundaryIdentifierGeneratorFactory(this.boundaryIdentifierGeneratorFactory).build();
        if (requestKeyStore.getSelfCertificate() != null && requestKeyStore.getSelfPrivateKey() != null && messageInfo.getMdnSigningAlgorithm() != HashAlgorithm.UNSIGNED) {
            HashAlgorithm mdnSigningHashAlgorithm = null;
            if (messageInfo.getMdnSigningAlgorithm() != null) {
                mdnSigningHashAlgorithm = HashAlgorithm.findByAlgorithm(messageInfo.getMdnSigningAlgorithm().algorithm());
            }
            return this.getSignedMultipartReport(requestKeyStore.getSelfPrivateKey(), requestKeyStore.getSelfCertificate(), mdnSigningHashAlgorithm, multipartReport);
        }
        return multipartReport;
    }

    private boolean isMdnRequired(MultiMap<String, String> httpHeaders) {
        return httpHeaders.get((Object)"Disposition-Notification-To") != null;
    }

    private AS2MessageIdGeneratorFactory getAs2MessageIdGeneratorFactory() {
        return this.as2MessageIdGeneratorFactory;
    }

    private MimePart getSignedMultipartReport(PrivateKey selfPrivateKey, Certificate selfCertificate, HashAlgorithm mdnSigningAlgorithm, MimePart multipartReport) {
        AS2Digest as2Digest = new AS2Digest().withContent(new MimePartInputStream(multipartReport)).withAlgorithm(mdnSigningAlgorithm).initialise();
        return new SignedMimeMultipartBuilder().withPrivateKey(selfPrivateKey).withSelfCertificate(selfCertificate).withDigest(as2Digest).withMimePart(multipartReport).withBoundaryIdentifierGeneratorFactory(this.boundaryIdentifierGeneratorFactory).build();
    }

    private MultiMap<String, String> getCommonAS2HttpHeaders(MultiMap<String, String> mdnHeaders, String as2From, String as2To) {
        mdnHeaders.put((Object)"Mime-Version", (Object)"1.0");
        mdnHeaders.put((Object)"AS2-Version", (Object)"1.1");
        mdnHeaders.put((Object)"AS2-To", (Object)as2From);
        mdnHeaders.put((Object)"AS2-From", (Object)as2To);
        String newMessageID = this.getAs2MessageIdGeneratorFactory().getInstance().generateMessageId(as2To, as2From);
        mdnHeaders.put((Object)"Message-ID", (Object)newMessageID);
        return mdnHeaders;
    }

    private boolean isAsyncMdnRequested(CaseInsensitiveMultiMap httpHeaders) {
        return httpHeaders.containsKey((Object)"Receipt-Delivery-Option");
    }

    String findFileName(String contentDisposition) {
        String fileName = null;
        Matcher fileNameMatcher = CONTENT_DISPOSITION.matcher(contentDisposition);
        if (fileNameMatcher.find()) {
            fileName = fileNameMatcher.group("fileName");
        }
        return fileName;
    }

    private void loadReceiveAttributesBuilder(AbstractReceiveAttributesBuilder attributesBuilder, Map<String, String> httpHeaders) {
        MultiMap newHttpHeadersMap = new MultiMap();
        for (Map.Entry<String, String> entry : httpHeaders.entrySet()) {
            List<String> list = Collections.singletonList(entry.getValue());
            newHttpHeadersMap.put((Object)entry.getKey(), list);
        }
        attributesBuilder.withFromName(httpHeaders.get("AS2-From")).withToName(httpHeaders.get("AS2-To")).withAs2MessageId(httpHeaders.get("Message-ID")).withHeaders((MultiMap<String, String>)newHttpHeadersMap);
    }
}

