/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime;

import com.mulesoft.connector.as2.internal.enums.EncodingType;
import com.mulesoft.connector.as2.internal.mime.MimeHeaders;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class MimeHeaderSerializer {
    private MimeHeaders headers;
    private static final String MIME_HEADER_FORMAT = "%s: %s\r\n";
    private static final String EMPTY_STRING = "";

    public MimeHeaderSerializer(MimeHeaders headers) {
        this.headers = headers;
    }

    public InputStream serializeEntityHeaders() {
        return new ByteArrayInputStream((this.serializeContentType() + this.serializeContentTransferEncoding() + this.serializeContentId() + this.serializeContentDescription() + this.serializeMimeExtensionHeaders()).getBytes());
    }

    String serializeMimeExtensionHeaders() {
        StringBuilder extensionHeaders = new StringBuilder();
        for (Map.Entry<String, String> header : this.headers.getExtensionHeaders().entrySet()) {
            extensionHeaders.append(String.format(MIME_HEADER_FORMAT, header.getKey(), header.getValue()));
        }
        return extensionHeaders.toString();
    }

    String serializeContentType() {
        String contentType = this.headers.getContentType();
        if (contentType != null) {
            return String.format(MIME_HEADER_FORMAT, "Content-Type", contentType);
        }
        return EMPTY_STRING;
    }

    String serializeContentTransferEncoding() {
        EncodingType contentTransferEncoding = this.headers.getContentTransferEncoding();
        if (contentTransferEncoding != null) {
            return String.format(MIME_HEADER_FORMAT, "Content-Transfer-Encoding", contentTransferEncoding.getCanonicalName());
        }
        return EMPTY_STRING;
    }

    String serializeContentDescription() {
        String contentDescription = this.headers.getContentDescription();
        if (contentDescription != null) {
            return String.format(MIME_HEADER_FORMAT, "Content-Description", contentDescription);
        }
        return EMPTY_STRING;
    }

    String serializeContentId() {
        String contentId = this.headers.getContentId();
        if (contentId != null) {
            return String.format(MIME_HEADER_FORMAT, "Content-ID", contentId);
        }
        return EMPTY_STRING;
    }
}

