/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.parse;

import com.mulesoft.connector.as2.internal.codec.CodecInputStream;
import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.DispositionType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.mime.MimeHeaders;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.parse.MimeContentParser;
import com.mulesoft.connector.as2.internal.mime.parse.MimeParserController;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.cms.CMSCompressedDataParser;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.jcajce.ZlibExpanderProvider;
import org.bouncycastle.operator.InputExpanderProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionMimeParser
implements MimeContentParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressionMimeParser.class);
    private static final Pattern SMIME_TYPE = Pattern.compile("smime-type=(?<smimeType>[^ ;]*)", 2);
    private static final String COMPRESSED_DATE = "compressed-data";
    private static final String APPLICATION_PKCS7_MIME = "application/pkcs7-mime";
    private static final String UNABLE_TO_DECOMPRESS_RECEIVED_MESSAGE = "unable to decompress received message";

    @Override
    public boolean canParseContentType(String contentType) {
        if (contentType == null) {
            return false;
        }
        Matcher m = SMIME_TYPE.matcher(contentType);
        if (contentType.toLowerCase().startsWith(APPLICATION_PKCS7_MIME) && m.find()) {
            return m.group("smimeType").equalsIgnoreCase(COMPRESSED_DATE);
        }
        return false;
    }

    @Override
    public boolean digestRequired() {
        return false;
    }

    public MimePart parse(MimeHeaders mimeHeaders, InputStream is, MimeParserController mimeParserController) {
        LOGGER.debug("Parsing compressed MIME part.");
        is = this.getDecodedInputStream(mimeHeaders, is);
        try {
            CMSCompressedDataParser compressedDataParser = new CMSCompressedDataParser(is);
            CMSTypedStream cmsStream = compressedDataParser.getContent((InputExpanderProvider)new ZlibExpanderProvider());
            MimePart underlyingMimePart = mimeParserController.parse(cmsStream.getContentStream());
            while (is.read() != -1) {
            }
            LOGGER.debug("Finished parsing compressed MIME part.");
            return underlyingMimePart;
        }
        catch (IOException | CMSException e) {
            throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_DECOMPRESSION_FAILED, UNABLE_TO_DECOMPRESS_RECEIVED_MESSAGE, AS2ErrorType.INFLATE, e);
        }
    }

    private InputStream getDecodedInputStream(MimeHeaders mimeHeaders, InputStream is) {
        return CodecInputStream.builder(is, true).withEncoding(mimeHeaders.getContentTransferEncoding()).build();
    }
}

