/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.stream;

import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.mule.runtime.core.api.util.IOUtils;

public abstract class InputStreamResource {
    public static InputStreamResource saveToResource(InputStream inputStream) {
        try {
            return new CachedInputStreamResource(inputStream);
        }
        catch (IOException e) {
            throw new AS2ExtensionException("Failed to Cache an Input Stream.", e);
        }
    }

    public abstract InputStream asInputStream();

    public static class CachedInputStreamResource
    extends InputStreamResource {
        public static final String PROPERTY_BASE_PATH = "com.mulesoft.connectors.as2.";
        private static final int KB = 1024;
        private static final int DEFAULT_THRESHOLD = 65536;
        private static final int THRESHOLD;
        private static final File TEMP_FILE_DIR;
        private File fileResource;
        private byte[] arrayResource;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CachedInputStreamResource(InputStream is) throws IOException {
            block14: {
                try {
                    if (THRESHOLD == -1) {
                        this.arrayResource = IOUtils.toByteArray((InputStream)is);
                        break block14;
                    }
                    this.arrayResource = new byte[THRESHOLD];
                    int pos = 0;
                    int i = is.read();
                    while (i != -1 && pos < THRESHOLD) {
                        this.arrayResource[pos++] = (byte)i;
                        i = is.read();
                    }
                    if (i != -1) {
                        this.fileResource = TEMP_FILE_DIR == null ? File.createTempFile("as2", "tmp") : File.createTempFile("as2", "tmp", TEMP_FILE_DIR);
                        this.fileResource.deleteOnExit();
                        FileOutputStream os = new FileOutputStream(this.fileResource);
                        try {
                            IOUtils.copyLarge((InputStream)new ByteArrayInputStream(this.arrayResource), (OutputStream)os);
                            os.write(i);
                            IOUtils.copyLarge((InputStream)is, (OutputStream)os);
                            break block14;
                        }
                        finally {
                            try {
                                os.close();
                            }
                            finally {
                                this.arrayResource = null;
                            }
                        }
                    }
                    this.arrayResource = Arrays.copyOf(this.arrayResource, pos);
                }
                finally {
                    is.close();
                }
            }
        }

        @Override
        public InputStream asInputStream() {
            if (this.arrayResource != null) {
                return new ByteArrayInputStream(this.arrayResource);
            }
            if (this.fileResource != null) {
                try {
                    return new FileInputStream(this.fileResource);
                }
                catch (FileNotFoundException e) {
                    throw new AS2ExtensionException("Failed to Cache an Input Stream.", e);
                }
            }
            return null;
        }

        static {
            File f;
            String s = System.getProperty("com.mulesoft.connectors.as2.CachedOutputStream.OutputDirectory");
            TEMP_FILE_DIR = s != null ? ((f = new File(s)).exists() && f.isDirectory() ? f : null) : null;
            String v = System.getProperty("com.mulesoft.connectors.as2.CachedOutputStream.Threshold");
            THRESHOLD = v == null ? 65536 : Integer.parseInt(v) * 1024;
        }
    }
}

