/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.crypto;

import com.mulesoft.connector.as2.internal.crypto.AS2Digest;
import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.DispositionType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import java.security.Provider;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jcajce.provider.util.DigestFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedMessageVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignedMessageVerifier.class);
    private PublicKey publicKey;
    private Map<String, byte[]> hashes = new HashMap<String, byte[]>();
    private String id;

    public SignedMessageVerifier(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public boolean validateSignature(byte[] pkcs7Signature, AS2Digest as2Digest) {
        CMSSignedData cmsSignedData;
        LOGGER.info("Validating PKCS7 signature against digest");
        this.id = DigestFactory.getOID((String)as2Digest.getAlgorithm().algorithm()).getId();
        this.hashes.put(this.id, as2Digest.getHash());
        try {
            cmsSignedData = new CMSSignedData(this.hashes, pkcs7Signature);
        }
        catch (CMSException e) {
            throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_AUTHENTICATION_FAILED, "Unable to parse PKCS7 signature block", AS2ErrorType.SIGNATURE_VERIFY, e);
        }
        SignerInformationStore signers = cmsSignedData.getSignerInfos();
        if (signers.size() < 1) {
            throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_AUTHENTICATION_FAILED, "Signature had no signer information!", AS2ErrorType.SIGNATURE_VERIFY);
        }
        for (SignerInformation signer : signers.getSigners()) {
            try {
                SignerInformationVerifier signerInformationVerifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider((Provider)new BouncyCastleProvider()).build(this.publicKey);
                if (!signer.verify(signerInformationVerifier)) continue;
                return true;
            }
            catch (CMSException | OperatorCreationException e) {
                throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_AUTHENTICATION_FAILED, "Error verifying signature", AS2ErrorType.SIGNATURE_VERIFY, e);
            }
        }
        return false;
    }

    public String getHash() {
        return Base64.toBase64String((byte[])this.hashes.get(this.id));
    }
}

