/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.crypto;

import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.bc.BcPEMDecryptorProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2PEMParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2PEMParser.class);
    private static final String TAG_CLOSE = "-----";
    private static final String BEGIN_TAG = "-----BEGIN ";
    private static final String END_TAG = "-----END ";
    private static final String CERTIFICATE = "CERTIFICATE";
    private static final String ENCRYPTED_PRIVATE_KEY = "ENCRYPTED PRIVATE KEY";
    private static final String RSA_PRIVATE_KEY = "RSA PRIVATE KEY";
    public static final String PRIVATE_KEY = "PRIVATE KEY";
    private static final Pattern CERTIFICATE_PATTERN = Pattern.compile("(?<certificate>-----BEGIN CERTIFICATE-----[^\t]*-----END CERTIFICATE-----)", 2);
    private static final Pattern ENCRYPTED_PRIVATE_KEY_PATTERN = Pattern.compile("(?<encryptedPrivateKey>-----BEGIN ENCRYPTED PRIVATE KEY-----[^\t]*-----END ENCRYPTED PRIVATE KEY-----)", 2);
    private static final Pattern RSA_PRIVATE_KEY_PATTERN = Pattern.compile("(?<privateKey>-----BEGIN RSA PRIVATE KEY-----[^\t]*-----END RSA PRIVATE KEY-----)", 2);
    private static final Pattern PRIVATE_KEY_PATTERN = Pattern.compile("(?<privateKey>-----BEGIN PRIVATE KEY-----[^\t]*-----END PRIVATE KEY-----)", 2);
    private PublicKey publicKey;
    private Certificate certificate;
    private PrivateKey privateKey;
    private String password;
    private String pemContent;

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public AS2PEMParser withPemContent(String pemContent) {
        this.pemContent = pemContent;
        return this;
    }

    public AS2PEMParser withPassword(String password) {
        this.password = password;
        return this;
    }

    public AS2PEMParser build() {
        this.certificate = this.getCertificate(this.pemContent);
        this.publicKey = this.getPublicKeyFromPem(this.pemContent);
        this.privateKey = this.getPrivateKeyFromPem(this.pemContent, this.password);
        return this;
    }

    public Certificate getCertificate(String pemContent) {
        String pemCertificateBlock = this.findCertificateBlock(pemContent);
        if (pemCertificateBlock == null) {
            LOGGER.debug("Could not find the Certificate block in the provided pem file");
            return null;
        }
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X509");
            return factory.generateCertificate(new ByteArrayInputStream(pemCertificateBlock.getBytes()));
        }
        catch (CertificateException e) {
            throw new AS2ExtensionException("PEM parse failed to extract certificate from pem file", AS2ErrorType.CONFIGURATION, e);
        }
    }

    public String findCertificateBlock(String pemContent) {
        Matcher m = CERTIFICATE_PATTERN.matcher(pemContent);
        if (m.find()) {
            LOGGER.debug("Found Certificate block.");
            return m.group("certificate");
        }
        LOGGER.debug("Didnt Find Certificate block.");
        return null;
    }

    public String findEncryptedPrivateKeyBlock(String pemContent) {
        Matcher m = ENCRYPTED_PRIVATE_KEY_PATTERN.matcher(pemContent);
        if (m.find()) {
            LOGGER.debug("Found Encrypted Private key block.");
            return m.group("encryptedPrivateKey");
        }
        LOGGER.debug("Didnt Find Encrypted Private key block.");
        return null;
    }

    public String findRSAPrivateKeyBlock(String pemContent) {
        Matcher m = RSA_PRIVATE_KEY_PATTERN.matcher(pemContent);
        if (m.find()) {
            LOGGER.debug("Found RSA Private key block.");
            return m.group("privateKey");
        }
        LOGGER.debug("Didnt Find RSA Private key block.");
        return null;
    }

    public String findPrivateKeyBlock(String pemContent) {
        Matcher m = PRIVATE_KEY_PATTERN.matcher(pemContent);
        if (m.find()) {
            LOGGER.debug("Found Private key block.");
            return m.group("privateKey");
        }
        LOGGER.debug("Didnt Find Private key block.");
        return null;
    }

    private PublicKey getPublicKeyFromPem(String pemContent) {
        Certificate certificate = this.getCertificate(pemContent);
        if (certificate == null) {
            LOGGER.debug("Could not find the Public key because the Certificate block was not provided.");
            return null;
        }
        return certificate.getPublicKey();
    }

    public PrivateKey getPrivateKeyFromPem(String pemContent, String password) {
        String privateKeyBlock = this.getPrivateKeyBlock(pemContent);
        if (privateKeyBlock == null) {
            LOGGER.debug("No supported Private Key block was found in the provided PEM file");
            return null;
        }
        PEMParser pemParser = new PEMParser((Reader)new StringReader(privateKeyBlock));
        try {
            Object pemObject = pemParser.readObject();
            if (pemObject instanceof PEMKeyPair) {
                return this.getPrivateKeyFromPEMKeyPair((PEMKeyPair)pemObject);
            }
            if (pemObject instanceof PrivateKeyInfo) {
                return this.getPrivateKeyFromPrivateKeyInfo((PrivateKeyInfo)pemObject);
            }
            if (password != null && !password.equals("")) {
                char[] decryptionPassword = password.toCharArray();
                if (pemObject instanceof PKCS8EncryptedPrivateKeyInfo) {
                    return this.getPrivateKeyFromPKCS8EncryptedPrivateKeyInfo((PKCS8EncryptedPrivateKeyInfo)pemObject, decryptionPassword);
                }
                if (pemObject instanceof PEMEncryptedKeyPair) {
                    return this.getPrivateKeyFromPEMEncryptedKeyPair((PEMEncryptedKeyPair)pemObject, decryptionPassword);
                }
            } else {
                LOGGER.warn("Password was not provided and could not get the Private key!\r\nDid you forget to add a password for your private Key?");
            }
            return null;
        }
        catch (Exception e) {
            throw new AS2ExtensionException("PEM parse failed to extract encrypted private keyBlock from pem file", AS2ErrorType.CONFIGURATION, e);
        }
    }

    private String getPrivateKeyBlock(String pemContent) {
        LOGGER.debug("Trying to get private key by checking PEM file for encrypted Private Key block.");
        String privateKeyBlock = this.findEncryptedPrivateKeyBlock(pemContent);
        if (privateKeyBlock == null) {
            LOGGER.debug("Trying to get private key by parsing RSA Private Key block in provided pem file.");
            privateKeyBlock = this.findRSAPrivateKeyBlock(pemContent);
        }
        if (privateKeyBlock == null) {
            LOGGER.debug("Trying to get private key by parsing Private Key block in provided pem file.");
            privateKeyBlock = this.findPrivateKeyBlock(pemContent);
        }
        return privateKeyBlock;
    }

    private PrivateKey getPrivateKeyFromPrivateKeyInfo(PrivateKeyInfo pemObject) throws PEMException {
        JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("PrivateKeyInfo object found in PEM file. Getting Key pair now.");
        }
        PrivateKeyInfo privateKeyInfo = pemObject;
        PrivateKey privateKey = jcaPEMKeyConverter.getPrivateKey(privateKeyInfo);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Private key found = {}", (Object)this.foundPrivateKey(privateKey));
        }
        return privateKey;
    }

    private PrivateKey getPrivateKeyFromPEMKeyPair(PEMKeyPair pemObject) throws PEMException {
        JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("PEMKeyPair object found in PEM file. Getting Key pair now.");
        }
        PEMKeyPair keyPair = pemObject;
        PrivateKeyInfo privateKeyInfo = keyPair.getPrivateKeyInfo();
        PrivateKey privateKey = jcaPEMKeyConverter.getPrivateKey(privateKeyInfo);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Private key found = {}", (Object)this.foundPrivateKey(privateKey));
        }
        return privateKey;
    }

    private PrivateKey getPrivateKeyFromPKCS8EncryptedPrivateKeyInfo(PKCS8EncryptedPrivateKeyInfo pemObject, char[] decryptionPassword) throws OperatorCreationException, PKCSException, PEMException {
        JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("PKCS8EncryptedPrivateKeyInfo object found in PEM file. Getting Key pair now.");
        }
        InputDecryptorProvider decryptionProvider = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(decryptionPassword);
        PKCS8EncryptedPrivateKeyInfo keyInfo = pemObject;
        PrivateKeyInfo privateKeyInfo = keyInfo.decryptPrivateKeyInfo(decryptionProvider);
        PrivateKey privateKey = jcaPEMKeyConverter.getPrivateKey(privateKeyInfo);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Private key found = {}", (Object)this.foundPrivateKey(privateKey));
        }
        return privateKey;
    }

    private PrivateKey getPrivateKeyFromPEMEncryptedKeyPair(PEMEncryptedKeyPair pemObject, char[] decryptionPassword) throws IOException {
        JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("PEMEncryptedKeyPair object found in PEM file. Getting Key pair now.");
        }
        PEMEncryptedKeyPair encryptedKeyPair = pemObject;
        PEMKeyPair keyPair = encryptedKeyPair.decryptKeyPair((PEMDecryptorProvider)new BcPEMDecryptorProvider(decryptionPassword));
        PrivateKeyInfo privateKeyInfo = keyPair.getPrivateKeyInfo();
        PrivateKey privateKey = jcaPEMKeyConverter.getPrivateKey(privateKeyInfo);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Private key found = {}", (Object)this.foundPrivateKey(privateKey));
        }
        return privateKey;
    }

    private boolean foundPrivateKey(PrivateKey privateKey) {
        return privateKey != null;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

