/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.send;

import com.mulesoft.connector.as2.internal.crypto.AS2Digest;
import com.mulesoft.connector.as2.internal.enums.AS2Compression;
import com.mulesoft.connector.as2.internal.enums.EncodingType;
import com.mulesoft.connector.as2.internal.enums.EncryptionAlgorithm;
import com.mulesoft.connector.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connector.as2.internal.enums.RequestReceipt;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.MimePartInputStream;
import com.mulesoft.connector.as2.internal.mime.builder.AS2MessageIdGeneratorFactory;
import com.mulesoft.connector.as2.internal.mime.builder.BoundaryIdentifierGeneratorFactory;
import com.mulesoft.connector.as2.internal.mime.builder.CompressedMimePartBuilder;
import com.mulesoft.connector.as2.internal.mime.builder.ContentMimePartBuilder;
import com.mulesoft.connector.as2.internal.mime.builder.EncryptedMimePartBuilder;
import com.mulesoft.connector.as2.internal.mime.builder.SignedMimeMultipartBuilder;
import com.mulesoft.connector.as2.internal.stream.InputStreamResource;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2MessageBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2MessageBuilder.class);
    private static final HashAlgorithm DEFAULT_HASH_ALG_SHA1 = HashAlgorithm.SHA1;
    private BoundaryIdentifierGeneratorFactory boundaryIdentifierGeneratorFactory = new BoundaryIdentifierGeneratorFactory();
    private AS2MessageIdGeneratorFactory as2MessageIdGeneratorFactory = new AS2MessageIdGeneratorFactory();
    private String mimeType;
    private String fileName;
    private String contentDescription;
    private String sender;
    private String senderEmail;
    private String receiver;
    private String receiptDeliveryOption;
    private String signedMimeMessageContentType;
    private InputStream content;
    private RequestReceipt requestRequiresReceipt;
    private EncodingType contentTransferEncoding;
    private HashAlgorithm hashAlgorithm;
    private HashAlgorithm mdnHashAlgorithm;
    private EncryptionAlgorithm encryptionAlgorithm;
    private AS2Compression as2Compression;
    private PrivateKey privateKey;
    private Certificate selfCertificate;
    private Certificate partnerCertificate;
    private MultiMap<String, String> headers;
    private AS2Digest as2Digest;
    private boolean isNonRepudiationRequested;
    private InputStreamResource signedMimeMessage;
    private InputStreamResource finalisedAs2Message;

    public AS2MessageBuilder withBoundaryIdentifierGeneratorFactory(BoundaryIdentifierGeneratorFactory boundaryIdentifierGeneratorFactory) {
        this.boundaryIdentifierGeneratorFactory = boundaryIdentifierGeneratorFactory;
        return this;
    }

    public AS2MessageBuilder withAS2MessageIdGeneratorFactory(AS2MessageIdGeneratorFactory as2MessageIdGeneratorFactory) {
        this.as2MessageIdGeneratorFactory = as2MessageIdGeneratorFactory;
        return this;
    }

    public AS2MessageBuilder withMimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public AS2MessageBuilder withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public AS2MessageBuilder withContentDescription(String contentDescription) {
        this.contentDescription = contentDescription;
        return this;
    }

    public AS2MessageBuilder withContent(InputStream content) {
        this.content = content;
        return this;
    }

    public AS2MessageBuilder withContentTransferEncoding(EncodingType encoding) {
        this.contentTransferEncoding = encoding;
        return this;
    }

    public AS2MessageBuilder withSignatureHashAlgorithm(HashAlgorithm hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
        return this;
    }

    public AS2MessageBuilder withMdnSignatureHashAlgorithm(HashAlgorithm mdnHashAlgorithm) {
        this.mdnHashAlgorithm = mdnHashAlgorithm;
        return this;
    }

    public AS2MessageBuilder withEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    public AS2MessageBuilder withPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public AS2MessageBuilder withSelfCertificate(Certificate certificate) {
        this.selfCertificate = certificate;
        return this;
    }

    public AS2MessageBuilder withPartnerCertificate(Certificate certificate) {
        this.partnerCertificate = certificate;
        return this;
    }

    public AS2MessageBuilder withSender(String sender) {
        this.sender = sender;
        return this;
    }

    public AS2MessageBuilder withRespondToEmail(String senderEmail) {
        this.senderEmail = senderEmail;
        return this;
    }

    public AS2MessageBuilder withReceiver(String receiver) {
        this.receiver = receiver;
        return this;
    }

    public AS2MessageBuilder withReceiptRequired(RequestReceipt requestReceipt) {
        this.requestRequiresReceipt = requestReceipt;
        return this;
    }

    public AS2MessageBuilder withCompression(AS2Compression compression) {
        this.as2Compression = compression;
        return this;
    }

    public AS2MessageBuilder withReceiptDeliveryOption(String receiptDeliveryOption) {
        this.receiptDeliveryOption = receiptDeliveryOption;
        return this;
    }

    public AS2MessageBuilder build() {
        MimePart message = this.createUnsignedMimePart();
        if (this.hashAlgorithm != null && this.hashAlgorithm != HashAlgorithm.UNSIGNED) {
            message = this.createSignedMimePart(message);
            if (this.isNonRepudiationRequested) {
                this.signedMimeMessage = InputStreamResource.saveToResource(message.getContent());
                message.setContent(this.signedMimeMessage.asInputStream());
            }
            this.signedMimeMessageContentType = message.getHeaders().getContentType();
        }
        if (this.as2Compression != null && this.as2Compression != AS2Compression.NONE) {
            message = this.createCompressedMimePart(message);
        }
        if (this.encryptionAlgorithm != null && this.encryptionAlgorithm != EncryptionAlgorithm.UNENCRYPTED) {
            message = this.createEncryptedMimePart(message);
        }
        this.setFinalisedAs2Message(message);
        this.setHeaders(message);
        return this;
    }

    public InputStreamResource getSignedMimePartInputStream() {
        return this.signedMimeMessage;
    }

    public InputStreamResource getFinalisedAs2Message() {
        return this.finalisedAs2Message;
    }

    public AS2Digest getDigest() {
        return this.as2Digest;
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers;
    }

    protected MultiMap<String, String> setReceiptHeaders(MultiMap<String, String> headers) {
        if (this.requestRequiresReceipt != RequestReceipt.NONE) {
            headers.put((Object)"Disposition-Notification-To", (Object)this.senderEmail);
        }
        if (this.isSigningExpected()) {
            if (this.mdnHashAlgorithm == HashAlgorithm.UNSIGNED || this.mdnHashAlgorithm == null) {
                LOGGER.warn("Requesting a signed receipt without providing an explicit algorithm in sender configuration. Using SHA-1 by default.");
                this.mdnHashAlgorithm = DEFAULT_HASH_ALG_SHA1;
            }
            headers.put((Object)"Disposition-Notification-Options", (Object)String.format("signed-receipt-protocol=required,pkcs7-signature; signed-receipt-micalg=optional,%s", this.mdnHashAlgorithm.name()));
        }
        if (!StringUtils.isBlank((String)this.receiptDeliveryOption)) {
            LOGGER.info("Applying the A-Sync MDN request header: receipt-delivery-option");
            headers.put((Object)"Receipt-Delivery-Option", (Object)this.receiptDeliveryOption);
        }
        return headers;
    }

    public String getSignedMimeMessageContentType() {
        return this.signedMimeMessageContentType;
    }

    public AS2MessageBuilder withNonRepudiationRequested(boolean nonRepudiationRequested) {
        this.isNonRepudiationRequested = nonRepudiationRequested;
        return this;
    }

    MimePart createSignedMimePart(MimePart contentMimePart) {
        this.as2Digest = new AS2Digest().withContent(new MimePartInputStream(contentMimePart)).withAlgorithm(this.hashAlgorithm).initialise();
        return new SignedMimeMultipartBuilder().withPrivateKey(this.privateKey).withSelfCertificate(this.selfCertificate).withDigest(this.as2Digest).withMimePart(contentMimePart).withBoundaryIdentifierGeneratorFactory(this.boundaryIdentifierGeneratorFactory).build();
    }

    private void setFinalisedAs2Message(MimePart message) {
        this.finalisedAs2Message = InputStreamResource.saveToResource(message.getContent());
    }

    private boolean isSigningExpected() {
        return this.requestRequiresReceipt == RequestReceipt.SIGNED_OPTIONAL || this.requestRequiresReceipt == RequestReceipt.SIGNED_REQUIRED;
    }

    private void setHeaders(final MimePart message) {
        MultiMap<String, String> httpHeaders = new MultiMap<String, String>(){
            {
                this.put("Mime-Version", "1.0");
                this.put("AS2-Version", "1.1");
                this.put("AS2-From", AS2MessageBuilder.this.getEscapedValue(AS2MessageBuilder.this.sender));
                this.put("AS2-To", AS2MessageBuilder.this.getEscapedValue(AS2MessageBuilder.this.receiver));
                this.put("Message-ID", AS2MessageBuilder.this.as2MessageIdGeneratorFactory.getInstance().generateMessageId(AS2MessageBuilder.this.sender, AS2MessageBuilder.this.receiver));
                this.putAll((Map)((Object)message.getHeaders()));
            }
        };
        this.headers = this.setReceiptHeaders(httpHeaders);
    }

    private String getEscapedValue(String value) {
        if (value != null && value.contains(" ")) {
            return "\"" + value + "\"";
        }
        return value;
    }

    private MimePart createUnsignedMimePart() {
        return new ContentMimePartBuilder().withDefaultDisposition().withContentType(this.mimeType).withFileName(this.fileName).withContentDescription(this.contentDescription).withContentTransferEncoding(this.contentTransferEncoding).withContent(this.content).build();
    }

    private MimePart createEncryptedMimePart(MimePart mimePart) {
        return new EncryptedMimePartBuilder().withEncryptionAlgorithm(this.encryptionAlgorithm).withCertificate((X509Certificate)this.partnerCertificate).withMimePart(mimePart).build();
    }

    private MimePart createCompressedMimePart(MimePart mimePart) {
        return new CompressedMimePartBuilder().withMimePart(mimePart).build();
    }
}

