/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.crypto;

import com.mulesoft.connector.as2.internal.crypto.PKCS7SignatureBlockBuilder;
import com.mulesoft.connector.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;

public class PKCS7SignatureBlock {
    private static final String GENERATING_THE_ENCODED_PKCS_7_OBJECT_FAILED = "Generating the encoded PKCS7 object failed";
    private List<java.security.cert.Certificate> certificates;
    private List<byte[]> encryptedHashes;
    private List<HashAlgorithm> hashAlgorithms;

    public static PKCS7SignatureBlockBuilder builder() {
        return new PKCS7SignatureBlockBuilder();
    }

    public byte[] asn1EncodedPKCS7() {
        CMSSignedDataGenerator cmsSignedDataGenerator = new CMSSignedDataGenerator();
        this.addCertificatesToSignedData(cmsSignedDataGenerator);
        this.addSignerInfoToSignedData(cmsSignedDataGenerator);
        CMSProcessableByteArray msg = new CMSProcessableByteArray(new byte[0]);
        try {
            return cmsSignedDataGenerator.generate((CMSTypedData)msg, false).getEncoded();
        }
        catch (IOException | CMSException e) {
            throw new AS2ExtensionException(GENERATING_THE_ENCODED_PKCS_7_OBJECT_FAILED, e);
        }
    }

    private void addSignerInfoToSignedData(CMSSignedDataGenerator cmsSignedDataGenerator) {
        Iterator<java.security.cert.Certificate> certificateIterator = this.certificates.iterator();
        Iterator<byte[]> encryptedHashIterator = this.encryptedHashes.iterator();
        Iterator<HashAlgorithm> algorithmIterator = this.hashAlgorithms.iterator();
        while (certificateIterator.hasNext() && encryptedHashIterator.hasNext() && algorithmIterator.hasNext()) {
            NonSigner nonSigner = new NonSigner(algorithmIterator.next(), encryptedHashIterator.next());
            try {
                Certificate cert = Certificate.getInstance((Object)ASN1Primitive.fromByteArray((byte[])certificateIterator.next().getEncoded()));
                JcaSignerInfoGeneratorBuilder signerInfoBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build());
                signerInfoBuilder.setDirectSignature(true);
                cmsSignedDataGenerator.addSignerInfoGenerator(signerInfoBuilder.build((ContentSigner)nonSigner, new X509CertificateHolder(cert)));
            }
            catch (IOException | CertificateEncodingException | OperatorCreationException e) {
                throw new AS2ExtensionException("Adding signer info to the PKCS7 object failed", e);
            }
        }
    }

    private void addCertificatesToSignedData(CMSSignedDataGenerator cmsSignedDataGenerator) {
        try {
            JcaCertStore certificateStore = new JcaCertStore(this.certificates);
            cmsSignedDataGenerator.addCertificates((Store)certificateStore);
        }
        catch (CertificateEncodingException | CMSException e) {
            throw new AS2ExtensionException("Adding certificates to the PKCS7 object failed", e);
        }
    }

    List<java.security.cert.Certificate> getCertificates() {
        return this.certificates;
    }

    void setCertificates(List<java.security.cert.Certificate> certificates) {
        this.certificates = certificates;
    }

    List<byte[]> getEncryptedHashes() {
        return this.encryptedHashes;
    }

    void setEncryptedHashes(List<byte[]> encryptedHashes) {
        this.encryptedHashes = encryptedHashes;
    }

    List<HashAlgorithm> getHashAlgorithms() {
        return this.hashAlgorithms;
    }

    void setHashAlgorithms(List<HashAlgorithm> hashAlgorithms) {
        this.hashAlgorithms = hashAlgorithms;
    }

    private class NonSigner
    implements ContentSigner {
        private HashAlgorithm hashAlgorithm;
        private byte[] encryptedHash;

        public NonSigner(HashAlgorithm hashAlgorithm, byte[] encryptedHash) {
            this.hashAlgorithm = hashAlgorithm;
            this.encryptedHash = encryptedHash;
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return new DefaultSignatureAlgorithmIdentifierFinder().find(this.hashAlgorithm.name() + "withRSA");
        }

        public OutputStream getOutputStream() {
            return new ByteArrayOutputStream();
        }

        public byte[] getSignature() {
            return this.encryptedHash;
        }
    }
}

