/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.builder;

import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.MimePartInputStream;
import com.mulesoft.connector.as2.internal.mime.builder.BoundaryIdentifierGeneratorFactory;
import com.mulesoft.connector.as2.internal.mime.builder.MimePartBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class MimeMultipartBuilder
extends MimePartBuilder {
    static final String BOUNDARY_MARKER = "--";
    static final String CRLF = "\r\n";
    List<MimePart> mimeParts = new ArrayList<MimePart>();
    String boundaryIdentifier;
    String boundary;
    String boundaryEnd;
    BoundaryIdentifierGeneratorFactory boundaryIdentifierGeneratorFactory = new BoundaryIdentifierGeneratorFactory();

    public MimeMultipartBuilder withBoundaryIdentifierGeneratorFactory(BoundaryIdentifierGeneratorFactory boundaryIdentifierGeneratorFactory) {
        this.boundaryIdentifierGeneratorFactory = boundaryIdentifierGeneratorFactory;
        return this;
    }

    public MimeMultipartBuilder withMimePart(MimePart mimePart) {
        if (mimePart != null) {
            this.mimeParts.add(mimePart);
        }
        return this;
    }

    @Override
    public MimePart build() {
        MimePart multipart = new MimePart();
        this.boundaryIdentifier = this.boundaryIdentifierGeneratorFactory.getInstance().generateBoundaryIdentifier();
        this.boundary = "\r\n--" + this.boundaryIdentifier + CRLF;
        this.boundaryEnd = "\r\n--" + this.boundaryIdentifier + BOUNDARY_MARKER + CRLF;
        this.content = this.composeContent();
        this.headers.setContentType(String.format("%s; boundary=\"%s\"", this.headers.getContentType(), this.boundaryIdentifier));
        multipart.setBoundaryIdentifier(this.boundaryIdentifier);
        multipart.setMimeParts(this.mimeParts);
        multipart.setHeaders(this.headers);
        multipart.setContent(this.content);
        return multipart;
    }

    protected InputStream composeContent() {
        Vector<InputStream> allTheStreams = new Vector<InputStream>();
        for (MimePart mimePart : this.mimeParts) {
            allTheStreams.add(new ByteArrayInputStream(this.boundary.getBytes()));
            allTheStreams.add(new MimePartInputStream(mimePart));
        }
        allTheStreams.add(new ByteArrayInputStream(this.boundaryEnd.getBytes()));
        return new SequenceInputStream(allTheStreams.elements());
    }
}

