/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.receive;

import com.mulesoft.connector.as2.internal.crypto.AS2Digest;
import com.mulesoft.connector.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connector.as2.internal.enums.RequiredSecurityLevel;
import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.DispositionType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.mime.MimeHeaders;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.MimePartFinder;
import com.mulesoft.connector.as2.internal.mime.MimePartInputStream;
import com.mulesoft.connector.as2.internal.mime.SignedMimeMultipart;
import com.mulesoft.connector.as2.internal.mime.builder.AS2MessageIdGeneratorFactory;
import com.mulesoft.connector.as2.internal.mime.builder.BoundaryIdentifierGeneratorFactory;
import com.mulesoft.connector.as2.internal.mime.builder.MDNReportMultiPartBuilder;
import com.mulesoft.connector.as2.internal.mime.builder.SignedMimeMultipartBuilder;
import com.mulesoft.connector.as2.internal.mime.parse.EncryptedMimeParser;
import com.mulesoft.connector.as2.internal.mime.parse.MimeParserController;
import com.mulesoft.connector.as2.internal.mime.validate.MimeValidatorController;
import com.mulesoft.connector.as2.internal.mime.validate.SignedMimeMultipartValidator;
import com.mulesoft.connector.as2.internal.receive.AbstractReceiveAttributesBuilder;
import com.mulesoft.connector.as2.internal.receive.MDN;
import com.mulesoft.connector.as2.internal.receive.ReceiveHandlerCallback;
import com.mulesoft.connector.as2.internal.receive.ReceivedMessageInfo;
import com.mulesoft.connector.as2.internal.receive.RequestKeyStore;
import com.mulesoft.connector.as2.internal.receive.SignedMimeMessageAttributes;
import com.mulesoft.connector.as2.internal.utils.AS2PatternMatchers;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceiveHandler.class);
    private BoundaryIdentifierGeneratorFactory boundaryIdentifierGeneratorFactory = new BoundaryIdentifierGeneratorFactory();
    private AS2MessageIdGeneratorFactory as2MessageIdGeneratorFactory = new AS2MessageIdGeneratorFactory();
    private boolean isEncrypted = false;
    private boolean isSigned = false;

    void setEncrypted(boolean encrypted) {
        this.isEncrypted = encrypted;
    }

    void setSigned(boolean signed) {
        this.isSigned = signed;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public ReceiveHandler withBoundaryIdentifierGeneratorFactory(BoundaryIdentifierGeneratorFactory boundaryIdentifierGeneratorFactory) {
        this.boundaryIdentifierGeneratorFactory = boundaryIdentifierGeneratorFactory;
        return this;
    }

    public ReceiveHandler withAS2MessageIdGeneratorFactory(AS2MessageIdGeneratorFactory as2MessageIdGeneratorFactory) {
        this.as2MessageIdGeneratorFactory = as2MessageIdGeneratorFactory;
        return this;
    }

    public void receiveAS2Message(CaseInsensitiveMultiMap httpHeaders, InputStream content, AbstractReceiveAttributesBuilder attributesBuilder, RequestKeyStore requestKeyStore, ReceiveHandlerCallback callback, boolean doNonRepudiation, RequiredSecurityLevel requiredSecurityLevel) {
        ReceivedMessageInfo messageInfo = new ReceivedMessageInfo();
        messageInfo.setContent(content);
        messageInfo.setHttpHeaders(httpHeaders);
        this.receiveAS2Message(messageInfo, attributesBuilder, requestKeyStore, callback, doNonRepudiation, requiredSecurityLevel);
    }

    MDN buildMDN(RequestKeyStore requestKeyStore, ReceivedMessageInfo messageInfo, byte[] originalMsgAS2DigestHash, DispositionType dispositionType) {
        MDN mdn = new MDN();
        String recipient = (String)messageInfo.getHttpHeaders().get((Object)"AS2-To");
        HashAlgorithm originalMicAlg = null;
        if (messageInfo.getAs2Digest() != null) {
            originalMicAlg = messageInfo.getAs2Digest().getAlgorithm();
        }
        if (originalMsgAS2DigestHash != null) {
            mdn.setOriginalMicAlgorithm(originalMicAlg);
            mdn.setOriginalMic(new String(Base64.getEncoder().encode(originalMsgAS2DigestHash)));
            mdn.setOriginalMessageId((String)messageInfo.getHttpHeaders().get((Object)"Message-ID"));
        }
        MimePart multipartReport = new MDNReportMultiPartBuilder().withFileName(messageInfo.getFileName()).withOriginalMessageId((String)messageInfo.getHttpHeaders().get((Object)"Message-ID")).withFromPartnerName((String)messageInfo.getHttpHeaders().get((Object)"AS2-From")).withOriginalRecipient(recipient).withFinalRecipient(recipient).withReceiveDate(ZonedDateTime.now()).withDispositionType(dispositionType).withOriginalMic(originalMsgAS2DigestHash).withOriginalMicAlg(originalMicAlg).withBoundaryIdentifierGeneratorFactory(this.boundaryIdentifierGeneratorFactory).build();
        if (this.isSignedMDN(requestKeyStore, messageInfo)) {
            HashAlgorithm mdnSigningHashAlgorithm = HashAlgorithm.SHA1;
            if (messageInfo.getMdnSigningAlgorithm() != null) {
                mdnSigningHashAlgorithm = HashAlgorithm.findByAlgorithm(messageInfo.getMdnSigningAlgorithm().algorithm());
            } else {
                LOGGER.warn("An algorithm for signing the response mdn was not found on the original received message, using SHA1 by default.");
            }
            mdn.setHashAlgorithm(mdnSigningHashAlgorithm);
            AS2Digest as2Digest = new AS2Digest().withContent(new MimePartInputStream(multipartReport)).withAlgorithm(mdnSigningHashAlgorithm).initialise();
            MimePart signedMultipartReport = new SignedMimeMultipartBuilder().withPrivateKey(requestKeyStore.getSelfPrivateKey()).withSelfCertificate(requestKeyStore.getSelfCertificate()).withDigest(as2Digest).withMimePart(multipartReport).withBoundaryIdentifierGeneratorFactory(this.boundaryIdentifierGeneratorFactory).build();
            mdn.setMdnMimePart(signedMultipartReport);
            return mdn;
        }
        mdn.setMdnMimePart(multipartReport);
        return mdn;
    }

    MimePart parseReceivedMessage(Map<String, String> httpHeaders, InputStream receivedMessage, PrivateKey privateKey, boolean isNonRepudiationEnabled) {
        MimeParserController mimeParserController = new MimeParserController(isNonRepudiationEnabled);
        EncryptedMimeParser encryptedMimeParser = new EncryptedMimeParser();
        if (encryptedMimeParser.canParseContentType(httpHeaders.get("Content-Type"))) {
            this.isEncrypted = true;
            if (privateKey == null) {
                LOGGER.error("Received message requiring decryption, but private key was null, please provide a valid private key.");
            }
            encryptedMimeParser.withPrivateKey(privateKey);
            mimeParserController.withContentParser(encryptedMimeParser);
        }
        try {
            return mimeParserController.parse(httpHeaders, receivedMessage);
        }
        catch (IOException e) {
            throw new AS2ExtensionException("Error parsing the received Content Stream", AS2ErrorType.MIME_PARSE, e);
        }
    }

    String findFileNameFrom(MimeHeaders mimeContentPartHeaders) {
        String fileName = null;
        if (mimeContentPartHeaders.containsKey("Content-Disposition")) {
            String contentDisposition = mimeContentPartHeaders.getContentDisposition();
            fileName = AS2PatternMatchers.findFileNameFrom(contentDisposition);
        }
        return fileName;
    }

    MultiMap<String, String> generateMDNHeaders(CaseInsensitiveMultiMap httpHeaders, MimeHeaders mimeHeaders) {
        MultiMap mdnHeaders = new MultiMap();
        mimeHeaders.forEach((arg_0, arg_1) -> ((MultiMap)mdnHeaders).put(arg_0, arg_1));
        mdnHeaders.put((Object)"Mime-Version", (Object)"1.0");
        mdnHeaders.put((Object)"AS2-Version", (Object)"1.1");
        String as2To = this.getMdnAs2FromHeader(httpHeaders, (MultiMap<String, String>)mdnHeaders);
        String as2From = this.getMdnAs2ToHeader(httpHeaders, (MultiMap<String, String>)mdnHeaders);
        String newMessageID = this.getAs2MessageIdGeneratorFactory().getInstance().generateMessageId(as2To, as2From);
        mdnHeaders.put((Object)"Message-ID", (Object)newMessageID);
        mdnHeaders.put((Object)"Subject", (Object)String.format("Message Received MDN Response for ID %s", mdnHeaders.get((Object)"Message-ID")));
        if (this.isAsyncMdnRequested(httpHeaders)) {
            String receiptDeliveryOption = (String)httpHeaders.get((Object)"Receipt-Delivery-Option");
            if (this.receiptDeliveryOptionMustStartWithHttp(receiptDeliveryOption)) {
                mdnHeaders.put((Object)"Recipient-Address", (Object)receiptDeliveryOption);
                LOGGER.info(String.format("The Async MDN recipient address is %s", receiptDeliveryOption));
            } else {
                String errorMessage = "The Recipient-Address %s obtained from Receipt-Delivery-Option was invalid as it did not start with http";
                throw new AS2ExtensionException(String.format(errorMessage, receiptDeliveryOption), AS2ErrorType.MIME_PARSE);
            }
        }
        return mdnHeaders;
    }

    void validateReceivedMessageSignature(MimePart receivedMimePart, PublicKey storePublicKey) {
        SignedMimeMultipartValidator signedMimeMultipartValidator = new SignedMimeMultipartValidator().withPublicKey(storePublicKey);
        MimeValidatorController validatorController = new MimeValidatorController().withValidator(signedMimeMultipartValidator);
        validatorController.validate(receivedMimePart);
    }

    private void receiveAS2Message(ReceivedMessageInfo messageInfo, AbstractReceiveAttributesBuilder attributesBuilder, RequestKeyStore requestKeyStore, ReceiveHandlerCallback callback, boolean doNonRepudiation, RequiredSecurityLevel requiredSecurityLevel) {
        MimePart receivedMimePart = null;
        try {
            messageInfo.setMdnSigningAlgorithm(this.getSigningAlgorithm(messageInfo));
            this.loadReceiveAttributesBuilderWithReceivedHttpHeaders(attributesBuilder, (Map<String, String>)messageInfo.getHttpHeaders());
            receivedMimePart = this.parseReceivedMessage((Map<String, String>)messageInfo.getHttpHeaders(), messageInfo.getContent(), requestKeyStore.getSelfPrivateKey(), doNonRepudiation);
            SignedMimeMessageAttributes signedMimeMessageAttributes = new SignedMimeMessageAttributes();
            if (doNonRepudiation) {
                if (receivedMimePart instanceof SignedMimeMultipart) {
                    SignedMimeMultipart signedMimeMultipart = (SignedMimeMultipart)receivedMimePart;
                    signedMimeMessageAttributes.setSignedMimeContent(signedMimeMultipart.getSignedMimeContent());
                    signedMimeMessageAttributes.setMicAlg(signedMimeMultipart.getContentDigest().getAlgorithm().algorithm());
                    signedMimeMessageAttributes.setMic(Base64.getEncoder().encodeToString(signedMimeMultipart.getContentDigest().getHash()));
                    signedMimeMessageAttributes.setContentType(signedMimeMultipart.getHeaders().getContentType());
                } else {
                    String errorMessage = String.format("Attempting to do Non Repudiation, but parsed Message was not Multipart Signed! Message id was: %s \n will attempt to send error MDN.", messageInfo.getHttpHeaders().get((Object)"Content-Type"));
                    LOGGER.error(errorMessage);
                    throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_UNEXPECTED_PROCESSING_ERROR, String.format(errorMessage, messageInfo.getHttpHeaders().get((Object)"Content-Type")), AS2ErrorType.NON_REPUDIATION_FAILURE);
                }
            }
            if (this.isMultipartSignedMessage(receivedMimePart)) {
                this.isSigned = true;
                PublicKey partnerPublicKey = requestKeyStore.getPartnerPublicKey();
                if (partnerPublicKey == null) {
                    LOGGER.error("Expected to be provided a Partners Public key to validate an incoming signed message!");
                } else {
                    this.processedSignedMessage(messageInfo, attributesBuilder, partnerPublicKey, receivedMimePart);
                }
            } else {
                this.processUnsignedMessage(messageInfo, attributesBuilder, receivedMimePart);
            }
            if (requiredSecurityLevel != null) {
                this.validateSecurityLevelOfReceivedMessage(requiredSecurityLevel);
            }
            if (this.isMdnRequired((MultiMap<String, String>)messageInfo.getHttpHeaders())) {
                this.notifyResult(requestKeyStore, callback, messageInfo, signedMimeMessageAttributes, DispositionType.PROCESSED, true, receivedMimePart);
            } else {
                MDN mdn = new MDN();
                mdn.setProcessed(false);
                signedMimeMessageAttributes.setMdn(mdn);
                callback.notifyResult(messageInfo.getContent(), signedMimeMessageAttributes, null, receivedMimePart);
            }
        }
        catch (AS2ExtensionException exception) {
            LOGGER.debug("Error handling request. Attempting to generate response error mdn.", (Throwable)((Object)exception));
            this.doErrorMdnResponse(requestKeyStore, callback, messageInfo, exception.getDisposition(), receivedMimePart);
        }
        catch (Throwable e) {
            LOGGER.error(e.getMessage(), e);
            this.closeContentStream(messageInfo);
            callback.notifyError(e, receivedMimePart);
        }
    }

    void validateSecurityLevelOfReceivedMessage(RequiredSecurityLevel requiredSecurityLevel) throws AS2ExtensionException {
        switch (requiredSecurityLevel) {
            case SIGNED: {
                if (this.isSigned) break;
                throw new AS2ExtensionException(DispositionType.INSUFFICIENT_MESSAGE_SECURITY, "Expected a signed message, but it was not.", AS2ErrorType.SECURITY_LEVEL);
            }
            case ENCRYPTED: {
                if (this.isEncrypted) break;
                throw new AS2ExtensionException(DispositionType.INSUFFICIENT_MESSAGE_SECURITY, "Expected an Encrypted message, but it was not.", AS2ErrorType.SECURITY_LEVEL);
            }
            case SIGNED_ENCRYPTED: {
                if (this.isSigned && this.isEncrypted) break;
                throw new AS2ExtensionException(DispositionType.INSUFFICIENT_MESSAGE_SECURITY, "Expected an Encrypted and signed message, but it was not.", AS2ErrorType.SECURITY_LEVEL);
            }
        }
    }

    private boolean isSignedMDN(RequestKeyStore requestKeyStore, ReceivedMessageInfo messageInfo) {
        return requestKeyStore.getSelfCertificate() != null && requestKeyStore.getSelfPrivateKey() != null && messageInfo.getMdnSigningAlgorithm() != HashAlgorithm.UNSIGNED;
    }

    private boolean receiptDeliveryOptionMustStartWithHttp(String receiptDeliveryOption) {
        return receiptDeliveryOption.toLowerCase().startsWith("http");
    }

    private String getMdnAs2FromHeader(CaseInsensitiveMultiMap httpHeaders, MultiMap<String, String> mdnHeaders) {
        String as2To = (String)httpHeaders.get((Object)"AS2-To");
        mdnHeaders.put((Object)"AS2-From", (Object)as2To);
        return as2To;
    }

    private String getMdnAs2ToHeader(CaseInsensitiveMultiMap httpHeaders, MultiMap<String, String> mdnHeaders) {
        String as2From = (String)httpHeaders.get((Object)"AS2-From");
        mdnHeaders.put((Object)"AS2-To", (Object)as2From);
        return as2From;
    }

    private void closeContentStream(ReceivedMessageInfo messageInfo) {
        if (messageInfo.getContent() != null) {
            try {
                messageInfo.getContent().close();
            }
            catch (IOException ioe) {
                LOGGER.warn("Error closing message input stream", (Throwable)ioe);
            }
            messageInfo.setContent(null);
        }
    }

    private void processUnsignedMessage(ReceivedMessageInfo messageInfo, AbstractReceiveAttributesBuilder attributesBuilder, MimePart receivedMimePart) {
        Object digestMimePart = new MimePartFinder(MimePart::hasDigest).find(receivedMimePart);
        if (digestMimePart != null) {
            messageInfo.setAs2Digest(((MimePart)digestMimePart).getAs2Digest());
        }
        messageInfo.setFileName(this.findFileNameFrom(receivedMimePart.getHeaders()));
        String contentType = receivedMimePart.getHeaders().getContentType();
        attributesBuilder.withFileName(messageInfo.getFileName()).withMimeType(contentType);
        messageInfo.setContent(receivedMimePart.getContent());
    }

    private void processedSignedMessage(ReceivedMessageInfo messageInfo, AbstractReceiveAttributesBuilder attributesBuilder, PublicKey partnerPublicKey, MimePart receivedMimePart) {
        this.validateReceivedMessageSignature(receivedMimePart, partnerPublicKey);
        SignedMimeMultipart receivedSignedMimeMultipart = (SignedMimeMultipart)receivedMimePart;
        messageInfo.setAs2Digest(receivedSignedMimeMultipart.getContentDigest());
        MimePart contentMimePart = receivedMimePart.getMimeParts().get(0);
        messageInfo.setFileName(this.findFileNameFrom(contentMimePart.getHeaders()));
        attributesBuilder.withFileName(messageInfo.getFileName()).withMimeType(contentMimePart.getHeaders().getContentType());
        messageInfo.setContent(contentMimePart.getContent());
    }

    private void notifyResult(RequestKeyStore requestKeyStore, ReceiveHandlerCallback callback, ReceivedMessageInfo messageInfo, SignedMimeMessageAttributes signedMimeMessageAttributes, DispositionType dispositionType, boolean processed, MimePart receivedMimePart) {
        MDN mdn = this.buildMdn(requestKeyStore, messageInfo, dispositionType);
        mdn.setProcessed(processed);
        mdn.setMdnHttpHeaders(this.generateMDNHeaders(messageInfo.getHttpHeaders(), mdn.getMdnMimePart().getHeaders()));
        signedMimeMessageAttributes.setMdn(mdn);
        callback.notifyResult(messageInfo.getContent(), signedMimeMessageAttributes, dispositionType, receivedMimePart);
    }

    private boolean isMultipartSignedMessage(MimePart receivedMimePart) {
        return ((String)receivedMimePart.getHeaders().get("Content-Type")).startsWith("multipart/signed");
    }

    private MDN buildMdn(RequestKeyStore requestKeyStore, ReceivedMessageInfo messageInfo, DispositionType dispositionType) {
        if (messageInfo.getAs2Digest() == null) {
            return this.buildMDN(requestKeyStore, messageInfo, null, dispositionType);
        }
        byte[] digestHash = messageInfo.getAs2Digest().getHash();
        return this.buildMDN(requestKeyStore, messageInfo, digestHash, dispositionType);
    }

    private void doErrorMdnResponse(RequestKeyStore requestKeyStore, ReceiveHandlerCallback callback, ReceivedMessageInfo messageInfo, DispositionType errorDisposition, MimePart receivedMimePart) {
        this.closeContentStream(messageInfo);
        if (this.isMdnRequired((MultiMap<String, String>)messageInfo.getHttpHeaders())) {
            if (errorDisposition == null) {
                errorDisposition = DispositionType.PROCESSED_ERROR_UNEXPECTED_PROCESSING_ERROR;
            }
            this.notifyResult(requestKeyStore, callback, messageInfo, new SignedMimeMessageAttributes(), errorDisposition, false, receivedMimePart);
        }
    }

    private void loadReceiveAttributesBuilderWithReceivedHttpHeaders(AbstractReceiveAttributesBuilder attributesBuilder, Map<String, String> httpHeaders) {
        MultiMap newHttpHeadersMap = new MultiMap();
        for (Map.Entry<String, String> entry : httpHeaders.entrySet()) {
            List<String> list = Collections.singletonList(entry.getValue());
            newHttpHeadersMap.put((Object)entry.getKey(), list);
        }
        attributesBuilder.withFromName(httpHeaders.get("AS2-From")).withToName(httpHeaders.get("AS2-To")).withAs2MessageId(httpHeaders.get("Message-ID")).withHeaders((MultiMap<String, String>)newHttpHeadersMap);
    }

    private boolean isMdnRequired(final MultiMap<String, String> httpHeaders) {
        CaseInsensitiveMultiMap caseInsensitiveMultiMap = new CaseInsensitiveMultiMap(){
            {
                this.putAll(httpHeaders);
            }
        };
        return caseInsensitiveMultiMap.get((Object)"Disposition-Notification-To") != null;
    }

    private HashAlgorithm getSigningAlgorithm(ReceivedMessageInfo messageInfo) {
        CaseInsensitiveMultiMap httpHeaders = messageInfo.getHttpHeaders();
        String dispositionNotificationOption = (String)httpHeaders.get("Disposition-Notification-Options");
        return AS2PatternMatchers.findMicAlgorithmFrom(dispositionNotificationOption);
    }

    private boolean isAsyncMdnRequested(CaseInsensitiveMultiMap httpHeaders) {
        return httpHeaders.containsKey((Object)"Receipt-Delivery-Option");
    }

    private AS2MessageIdGeneratorFactory getAs2MessageIdGeneratorFactory() {
        return this.as2MessageIdGeneratorFactory;
    }
}

