/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.utils;

import com.mulesoft.connector.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2PatternMatchers {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2PatternMatchers.class);
    private static final Pattern ORIGINAL_MESSAGE_ID_PATTERN = Pattern.compile("\r\n[ \t]*Original-Message-ID[ \t]*:[ \t]*(?<originalMessageId>[^ \t\r\n]*)[ \t]*\r\n", 2);
    private static final Pattern SIGNED_RECEIPT_MIC_ALG_PATTERN = Pattern.compile("signed-receipt-micalg[ \t]*=[ \t]*(?<importance>optional|required)[ \t]*,[ \t]*(?<micAlg>[^ \t\r\n]*)", 2);
    private static final Pattern MIC_ALG = Pattern.compile("micalg=\"?(?<MicAlgorithm>[^; \t\r\n\"]*)", 2);
    private static final Pattern BOUNDARY_PATTERN = Pattern.compile("boundary=\"?(?<boundaryId>[^; \t\r\n\"]*)", 2);
    private static final Pattern RECEIVED_CONTENT_MIC_PATTERN = Pattern.compile("\r\n[ \t]*Received-Content-MIC[ \t]*:[ \t]*(?<MIC>[^, \t\r\n]*),[ \t](?<MicAlg>[^ \t\r\n]*)", 2);
    private static final Pattern DISPOSITION_PATTERN = Pattern.compile("\r\n[ \t]*Disposition[ \t]*:(?<processed>.*)\r\n", 2);
    private static final Pattern ORIGINAL_RECIPIENT = Pattern.compile("\r\n[ \t]*Original-Recipient[ \t]*:.*;[ \t]*(?<originalRecipient>[^ \t\r\n]*)?[ \t]*\r\n", 2);
    private static final Pattern FINAL_RECIPIENT = Pattern.compile("\r\n[ \t]*Final-Recipient[ \t]*:.*;[ \t]*(?<finalRecipient>[^ \t\r\n]*)?[ \t]*\r\n", 2);
    private static final Pattern CONTENT_DISPOSITION_PATTERN = Pattern.compile("filename=[\"]?(?<fileName>[^\"]*)[\"]?", 2);
    private static final Pattern SMIME_TYPE = Pattern.compile("smime-type=(?<smimeType>[^ ;]*)", 2);

    private AS2PatternMatchers() {
    }

    public static String findOriginalMessageIdFrom(String mdnContent) {
        Matcher m = ORIGINAL_MESSAGE_ID_PATTERN.matcher(mdnContent);
        if (m.find()) {
            return m.group("originalMessageId");
        }
        LOGGER.debug("Unable to parse Original-Message-ID in MDN report. Will return empty string.");
        return "";
    }

    public static HashAlgorithm findMicAlgorithmFrom(String dispositionNotificationOption) {
        Matcher m;
        if (dispositionNotificationOption != null && !dispositionNotificationOption.equals("") && (m = SIGNED_RECEIPT_MIC_ALG_PATTERN.matcher(dispositionNotificationOption)).find()) {
            String[] micAlgorithms;
            for (String micAlg : micAlgorithms = m.group("micAlg").split(",")) {
                HashAlgorithm algorithm = HashAlgorithm.findByAlgorithm(micAlg);
                if (algorithm == null) continue;
                return algorithm;
            }
            LOGGER.debug("Did not find a valid Hash Algorithm this AS2 connector supports in the Disposition notification options. This could be a possible issue requiring investigation. The supplied Mic algorithms in the processed {} were:", (Object)"Disposition-Notification-Options");
            for (String algorithms : micAlgorithms) {
                LOGGER.warn("{} ", (Object)algorithms);
            }
        }
        return HashAlgorithm.UNSIGNED;
    }

    public static HashAlgorithm findDigestAlgorithmFrom(String contentType) {
        Matcher m = MIC_ALG.matcher(contentType);
        if (m.find()) {
            String algorithm = m.group("MicAlgorithm");
            return HashAlgorithm.findByAlgorithm(algorithm);
        }
        throw new AS2ExtensionException("Could not read the mic algorithm in content type", AS2ErrorType.MIME_PARSE);
    }

    public static String findBoundaryIdentifierFrom(String contentType) {
        Matcher m = BOUNDARY_PATTERN.matcher(contentType);
        if (m.find()) {
            return m.group("boundaryId");
        }
        throw new AS2ExtensionException("Could not read the boundary identifier in content type", AS2ErrorType.MIME_PARSE);
    }

    public static String findReceivedContentMicFrom(String mdnContent) {
        Matcher m = RECEIVED_CONTENT_MIC_PATTERN.matcher(mdnContent);
        if (m.find()) {
            return m.group("MIC");
        }
        LOGGER.debug("Unable to parse received content mic in MDN report");
        return "";
    }

    public static HashAlgorithm findReceivedContentMicAlgorithmFrom(String mdnContent) {
        Matcher m = RECEIVED_CONTENT_MIC_PATTERN.matcher(mdnContent);
        if (m.find()) {
            String algorithm = m.group("MicAlg");
            try {
                return HashAlgorithm.valueOf(algorithm);
            }
            catch (IllegalArgumentException iae) {
                HashAlgorithm algEnum = HashAlgorithm.findByAlgorithm(algorithm);
                if (algEnum != null) {
                    return algEnum;
                }
                LOGGER.warn("Unable to parse digest algorithm in MDN report of {}", (Object)algorithm);
            }
        } else {
            LOGGER.debug("Unable to parse digest algorithm in MDN report");
        }
        return null;
    }

    public static boolean findDisposition(String mdnContent) {
        Matcher m = DISPOSITION_PATTERN.matcher(mdnContent);
        if (m.find()) {
            return m.group("processed").toLowerCase().trim().endsWith("processed");
        }
        LOGGER.debug("Unable to parse processed status in MDN report");
        return false;
    }

    public static String findOriginalRecipient(String mdnContent) {
        Matcher m = ORIGINAL_RECIPIENT.matcher(mdnContent);
        if (m.find()) {
            return m.group("originalRecipient");
        }
        LOGGER.debug("Unable to parse original recipient in MDN report");
        return "";
    }

    public static String findFinalRecipient(String mdnContent) {
        Matcher m = FINAL_RECIPIENT.matcher(mdnContent);
        if (m.find()) {
            return m.group("finalRecipient");
        }
        LOGGER.debug("Unable to parse final recipient in MDN report");
        return "";
    }

    public static String findFileNameFrom(String contentDisposition) {
        String fileName = null;
        Matcher fileNameMatcher = CONTENT_DISPOSITION_PATTERN.matcher(contentDisposition);
        if (fileNameMatcher.find()) {
            fileName = fileNameMatcher.group("fileName");
        }
        return fileName;
    }

    public static String findSMimeTypeFrom(String contentType) {
        Matcher m = SMIME_TYPE.matcher(contentType);
        if (contentType.toLowerCase().startsWith("application/pkcs7-mime") && m.find()) {
            return m.group("smimeType");
        }
        return null;
    }
}

