/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.crypto;

import com.mulesoft.connector.as2.internal.crypto.AS2Digest;
import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.DispositionType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.utils.AS2BouncyCastleProvider;
import java.security.Provider;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jcajce.provider.util.DigestFactory;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedMessageVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignedMessageVerifier.class);
    private PublicKey publicKey;
    private Map<String, byte[]> hashes = new HashMap<String, byte[]>();
    private String id;

    public SignedMessageVerifier(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public boolean validateSignature(byte[] pkcs7Signature, AS2Digest as2Digest) {
        CMSSignedData cmsSignedData;
        LOGGER.info("Validating PKCS7 signature against digest");
        this.id = DigestFactory.getOID((String)as2Digest.getAlgorithm().algorithm()).getId();
        this.hashes.put(this.id, as2Digest.getHash());
        try {
            LOGGER.debug("CMSUtils reading ContentInfo from pkcs7Signature");
            cmsSignedData = new CMSSignedData(this.hashes, pkcs7Signature);
        }
        catch (CMSException e) {
            String pkcs7ParsingError = "Unable to parse PKCS7 signature block";
            LOGGER.debug(pkcs7ParsingError, (Throwable)e);
            throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_AUTHENTICATION_FAILED, pkcs7ParsingError, AS2ErrorType.SIGNATURE_VERIFY, e);
        }
        LOGGER.debug("finding signers information");
        SignerInformationStore signers = cmsSignedData.getSignerInfos();
        if (signers.size() < 1) {
            LOGGER.debug("No signer found for given data");
            throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_AUTHENTICATION_FAILED, "Signature had no signer information!", AS2ErrorType.SIGNATURE_VERIFY);
        }
        for (SignerInformation signer : signers.getSigners()) {
            try {
                SignerInformationVerifier signerInformationVerifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider((Provider)AS2BouncyCastleProvider.getBouncyCastleProvider()).build(this.publicKey);
                if (!signer.verify(signerInformationVerifier)) continue;
                LOGGER.debug("Signer was verified.");
                return true;
            }
            catch (CMSException | OperatorCreationException e) {
                LOGGER.debug("There was an error while trying to verify signer");
                throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_AUTHENTICATION_FAILED, "Error verifying signature", AS2ErrorType.SIGNATURE_VERIFY, e);
            }
        }
        LOGGER.debug("The signer could not be verified.");
        return false;
    }

    public String getHash() {
        return Base64.toBase64String((byte[])this.hashes.get(this.id));
    }
}

