/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.parse;

import com.mulesoft.connector.as2.internal.crypto.AS2Digest;
import com.mulesoft.connector.as2.internal.crypto.DigestingInputStream;
import com.mulesoft.connector.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connector.as2.internal.mime.MimeHeaders;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.PKCS7MimePart;
import com.mulesoft.connector.as2.internal.mime.SignedMimeMultipart;
import com.mulesoft.connector.as2.internal.mime.parse.MimeBoundaryAwareInputStream;
import com.mulesoft.connector.as2.internal.mime.parse.MimeContentParser;
import com.mulesoft.connector.as2.internal.mime.parse.MimeParserController;
import com.mulesoft.connector.as2.internal.stream.InputStreamResource;
import com.mulesoft.connector.as2.internal.utils.AS2PatternMatchers;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedMimeMultipartParser
implements MimeContentParser<SignedMimeMultipart> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignedMimeMultipartParser.class);
    private static final String CRLF = "\r\n";
    private static final String BOUNDARY_PREFIX = "\r\n--";
    private static final String BOUNDARY_SUFFIX = "--\r\n";
    private boolean isNonRepudiationEnabled = false;

    public SignedMimeMultipartParser(boolean isNonRepudiationEnabled) {
        this.isNonRepudiationEnabled = isNonRepudiationEnabled;
    }

    @Override
    public boolean canParseContentType(String contentType) {
        return contentType != null && contentType.toLowerCase().startsWith("multipart/signed");
    }

    @Override
    public boolean digestRequired() {
        return false;
    }

    @Override
    public SignedMimeMultipart parse(MimeHeaders mimeHeaders, InputStream is, MimeParserController mimeParserController) throws IOException {
        LOGGER.debug("Parsing Signed MIME Multipart");
        SignedMimeMultipart signedMimeMultiPart = new SignedMimeMultipart();
        if (this.isNonRepudiationEnabled) {
            LOGGER.debug("Saving Signed Mime Message for Non Repudiation");
            InputStreamResource singedMimeMessage = InputStreamResource.saveToResource(is);
            signedMimeMultiPart.setSignedMimeMessage(singedMimeMessage);
            is = singedMimeMessage.asInputStream();
        }
        signedMimeMultiPart.setHeaders(mimeHeaders);
        LOGGER.debug(String.format("Finding Boundary Identifier with contentType %s", mimeHeaders.getContentType()));
        String boundaryIdentifier = AS2PatternMatchers.findBoundaryIdentifierFrom(mimeHeaders.getContentType());
        signedMimeMultiPart.setBoundaryIdentifier(boundaryIdentifier);
        int boundaryEndPaddedLength = (BOUNDARY_PREFIX + boundaryIdentifier + BOUNDARY_SUFFIX).length();
        PushbackInputStream pushbackInputStream = new PushbackInputStream(is, boundaryEndPaddedLength);
        HashAlgorithm hashAlgorithm = AS2PatternMatchers.findDigestAlgorithmFrom(mimeHeaders.getContentType());
        LOGGER.debug("Initialising as2Digest.");
        MimeBoundaryAwareInputStream content = new MimeBoundaryAwareInputStream(pushbackInputStream, boundaryIdentifier);
        AS2Digest as2Digest = new AS2Digest().withContent(content).withAlgorithm(hashAlgorithm).initialise();
        DigestingInputStream signedContentInputStream = as2Digest.getDigestingInputStream();
        MimePart signedContentMimePart = mimeParserController.parse(signedContentInputStream);
        signedMimeMultiPart.addMimePart(signedContentMimePart);
        signedMimeMultiPart.setContentDigest(as2Digest);
        MimeBoundaryAwareInputStream signatureContentInputStream = new MimeBoundaryAwareInputStream(pushbackInputStream, boundaryIdentifier);
        MimePart signatureContentMimePart = mimeParserController.parse(signatureContentInputStream);
        signedMimeMultiPart.addMimePart(signatureContentMimePart);
        signedMimeMultiPart.setPkcs7Signature(((PKCS7MimePart)signatureContentMimePart).getPkcs7Bytes());
        LOGGER.debug("Finished parsing Signed MIME Multipart");
        return signedMimeMultiPart;
    }
}

