/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.crypto;

import com.mulesoft.connector.as2.internal.crypto.EncryptionAlgorithmMapper;
import com.mulesoft.connector.as2.internal.enums.EncryptionAlgorithm;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.stream.OutputTransformationInputStream;
import com.mulesoft.connector.as2.internal.utils.AS2BouncyCastleProvider;
import com.mulesoft.connector.as2.internal.utils.AS2Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.OutputEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS7EncryptedEnvelopeStreamBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PKCS7EncryptedEnvelopeStreamBuilder.class);
    private X509Certificate certificate;
    private EncryptionAlgorithm encryptionAlgorithm;
    private InputStream content;

    public PKCS7EncryptedEnvelopeStreamBuilder withCertificate(X509Certificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public PKCS7EncryptedEnvelopeStreamBuilder withEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    public PKCS7EncryptedEnvelopeStreamBuilder withContent(InputStream content) {
        this.content = content;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream build() {
        try {
            CMSEnvelopedDataStreamGenerator cmsEnvelopedDataGenerator = new CMSEnvelopedDataStreamGenerator();
            cmsEnvelopedDataGenerator.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(this.certificate));
            OutputEncryptor encryptor = new JceCMSContentEncryptorBuilder(EncryptionAlgorithmMapper.map(this.encryptionAlgorithm)).setProvider((Provider)AS2BouncyCastleProvider.getBouncyCastleProvider()).build();
            if (LOGGER.isTraceEnabled()) {
                ByteArrayOutputStream in1 = null;
                try {
                    in1 = AS2Utils.logInputStream(this.content, "CodecInputStreamBuilder/builder() - From PKCS7EncryptedEnvelopeStreamBuilder", LOGGER);
                    this.content = new ByteArrayInputStream(in1.toByteArray());
                }
                catch (Throwable throwable) {
                    AS2Utils.closeOutStream(in1, LOGGER);
                    throw throwable;
                }
                AS2Utils.closeOutStream(in1, LOGGER);
            }
            return new OutputTransformationInputStream(this.content, out -> {
                try {
                    return cmsEnvelopedDataGenerator.open(out, encryptor);
                }
                catch (CMSException e) {
                    LOGGER.debug("CMSException while trying to open cmsEnvelopedDataGenerator", (Throwable)e);
                    throw new IOException(e);
                }
            });
        }
        catch (IOException | CertificateEncodingException | CMSException e) {
            String errorMessage = "Error encrypting content with algorithm " + this.encryptionAlgorithm.name();
            LOGGER.error(errorMessage, e);
            throw new AS2ExtensionException(errorMessage, e);
        }
    }
}

