/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime;

import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.MimePartSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimePartFinder<T extends MimePart> {
    private final MimePartSelector selector;
    private static final Logger logger = LoggerFactory.getLogger(MimePartFinder.class);

    public MimePartFinder(MimePartSelector selector) {
        this.selector = selector;
    }

    public T find(MimePart mimePart) {
        logger.debug("Entering the MimePartFinder.find(mimePart) method.\nValidating mimePart by MimePartSelector criteria.");
        if (this.selector.select(mimePart)) {
            logger.debug("mimePart selected. Returning mimePart.");
            return (T)mimePart;
        }
        logger.debug("Checking condition 'mimePart.isMultiPart()'.");
        if (mimePart.isMultiPart()) {
            logger.debug("The mimePart is multi-part, so looking for each chunk.");
            for (MimePart childMimePart : mimePart.getMimeParts()) {
                T foundMimePart = this.find(childMimePart);
                if (foundMimePart == null) continue;
                logger.debug("childMimePart found. Returning childMimePart.");
                return foundMimePart;
            }
        }
        return null;
    }
}

