/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.crypto;

import com.mulesoft.connector.as2.internal.crypto.AS2Signature;
import com.mulesoft.connector.as2.internal.crypto.PKCS7SignatureBlock;
import com.mulesoft.connector.as2.internal.crypto.PKCS7SignatureBlockBuilder;
import com.mulesoft.connector.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connector.as2.internal.utils.AS2Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS7SignatureBlockInputStream
extends InputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(PKCS7SignatureBlockInputStream.class);
    private PKCS7SignatureBlockBuilder pkcs7SignatureBlockBuilder = PKCS7SignatureBlock.builder();
    private List<AS2Signature> signatures = new ArrayList<AS2Signature>();
    private InputStream in;

    public PKCS7SignatureBlockInputStream withSignature(AS2Signature signature) {
        this.signatures.add(signature);
        return this;
    }

    public PKCS7SignatureBlockInputStream withCertificate(Certificate certificate) {
        this.pkcs7SignatureBlockBuilder.withCertificate(certificate);
        return this;
    }

    public PKCS7SignatureBlockInputStream withHashAlgorithm(HashAlgorithm hashAlgorithm) {
        this.pkcs7SignatureBlockBuilder.withHashAlgorithm(hashAlgorithm);
        return this;
    }

    private void initialiseInputStream() {
        LOGGER.debug("initialising InputStream in PKCS7Signature.");
        if (this.in == null) {
            for (AS2Signature signature : this.signatures) {
                this.pkcs7SignatureBlockBuilder.withEncryptedHash(signature.sign());
            }
            PKCS7SignatureBlock pkcs7SignatureBlock = this.pkcs7SignatureBlockBuilder.build();
            this.in = new ByteArrayInputStream(pkcs7SignatureBlock.asn1EncodedPKCS7());
            if (LOGGER.isTraceEnabled()) {
                ByteArrayOutputStream is1 = null;
                try {
                    is1 = AS2Utils.logInputStream(this.in, "PKCS7SignatureBlockInputStream/read", LOGGER);
                    this.in = new ByteArrayInputStream(is1.toByteArray());
                }
                catch (Throwable throwable) {
                    AS2Utils.closeOutStream(is1, LOGGER);
                    throw throwable;
                }
                AS2Utils.closeOutStream(is1, LOGGER);
            }
        }
    }

    @Override
    public int read() throws IOException {
        LOGGER.debug("Starting Read()");
        this.initialiseInputStream();
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        LOGGER.debug("Starting Read(b)");
        this.initialiseInputStream();
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        LOGGER.debug("Starting Read(b, off. len)");
        this.initialiseInputStream();
        return this.in.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        this.initialiseInputStream();
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        this.initialiseInputStream();
        return this.in.skip(n);
    }
}

