/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.validate.processing;

import com.mulesoft.connector.as2.internal.enums.ProcessingStatus;
import com.mulesoft.connector.as2.internal.mime.MDNReport;
import com.mulesoft.connector.as2.internal.mime.validate.processing.BaseStatusResolver;
import com.mulesoft.connector.as2.internal.mime.validate.processing.InsufficientMessageSecurityStatusResolver;
import com.mulesoft.connector.as2.internal.mime.validate.processing.ProcessedStatusResolver;
import com.mulesoft.connector.as2.internal.mime.validate.processing.UnknownTradingPartnerStatusResolver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessingStatusHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessingStatusHandler.class);
    private static final Map<ProcessingStatus, BaseStatusResolver> resolversMap = new HashMap<ProcessingStatus, BaseStatusResolver>();

    public static BaseStatusResolver getStatusResolverByReport(MDNReport report) {
        String processedCode = ProcessingStatusHandler.getProcessedCodeFromReport(report);
        LOGGER.debug(String.format("The Partner answered you with processing status code '%s'", processedCode));
        return ProcessingStatusHandler.getResolverByProcessedCode(processedCode);
    }

    private static String getProcessedCodeFromReport(MDNReport report) {
        String processedStatus;
        String processedValue = ProcessingStatus.PROCESSED.getCanonicalName();
        if (report.getDispositionNotificationContent() != null && report.getDispositionNotificationContent().get((Object)"Disposition") != null && !(processedStatus = ((String)((List)report.getDispositionNotificationContent().get((Object)"Disposition")).get(1)).trim()).endsWith(ProcessingStatus.PROCESSED.getCanonicalName())) {
            processedValue = processedStatus.split(":")[1].trim();
        }
        return processedValue;
    }

    private static BaseStatusResolver getResolverByProcessedCode(String processedCode) {
        ProcessingStatus status = ProcessingStatus.findByCanonicalName(processedCode);
        return resolversMap.get((Object)status);
    }

    static {
        resolversMap.put(ProcessingStatus.PROCESSED, new ProcessedStatusResolver());
        resolversMap.put(ProcessingStatus.UNKNOWN_TRADING_PARTNER, new UnknownTradingPartnerStatusResolver());
        resolversMap.put(ProcessingStatus.INSUFFICIENT_MESSAGE_SECURITY, new InsufficientMessageSecurityStatusResolver());
    }
}

