/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.parse;

import com.mulesoft.connector.as2.internal.mime.parse.FIFOByteBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class MimeBoundaryAwareInputStream
extends InputStream {
    private static final String FIRST_BOUNDARY_MARKER_PATTERN = "--%s\r\n";
    private static final String BOUNDARY_MARKER_PATTERN = "\r\n--%s\r\n";
    private static final String BOUNDARY_END_MARKER_PATTERN = "\r\n--%s--\r\n";
    private String firstBoundaryMarker;
    private String boundaryMarker;
    private String boundaryEndMarker;
    private FIFOByteBuffer fifoBuffer;
    private PushbackInputStream originalInputStream;
    private boolean hasMoreParts;

    public MimeBoundaryAwareInputStream(PushbackInputStream is, String boundaryIdentifier) throws IOException {
        this.firstBoundaryMarker = String.format(FIRST_BOUNDARY_MARKER_PATTERN, boundaryIdentifier);
        this.boundaryMarker = String.format(BOUNDARY_MARKER_PATTERN, boundaryIdentifier);
        this.boundaryEndMarker = String.format(BOUNDARY_END_MARKER_PATTERN, boundaryIdentifier);
        this.fifoBuffer = new FIFOByteBuffer(this.boundaryEndMarker.length());
        this.originalInputStream = is;
        this.stripFirstBoundaryMarker(is);
    }

    private void stripFirstBoundaryMarker(PushbackInputStream is) throws IOException {
        FIFOByteBuffer firstBoundaryBuffer = new FIFOByteBuffer(this.firstBoundaryMarker.length());
        firstBoundaryBuffer.fillFifoBuffer(is);
        String bufferAsString = new String(firstBoundaryBuffer.getBytes());
        int nextByte = 0;
        while (!bufferAsString.equals(this.firstBoundaryMarker) && nextByte != -1) {
            nextByte = is.read();
            firstBoundaryBuffer.pushPull(nextByte);
            bufferAsString = new String(firstBoundaryBuffer.getBytes());
        }
    }

    @Override
    public int read() throws IOException {
        if (this.originalInputStream == null) {
            return -1;
        }
        int byteToRead = -1;
        if (this.fifoBuffer.isBufferEmpty() && this.fifoBuffer.fillFifoBuffer(this.originalInputStream) == -1) {
            return -1;
        }
        String bufferAsString = new String(this.fifoBuffer.getBytes());
        if (bufferAsString.equals(this.boundaryEndMarker)) {
            int i = this.originalInputStream.read();
            while (i >= 0) {
                i = this.originalInputStream.read();
            }
            this.originalInputStream = null;
            this.hasMoreParts = false;
            return -1;
        }
        if (bufferAsString.startsWith(this.boundaryMarker)) {
            this.originalInputStream.unread(this.fifoBuffer.getBytes());
            this.originalInputStream = null;
            this.hasMoreParts = true;
            return -1;
        }
        byteToRead = this.fifoBuffer.pushPull(this.originalInputStream.read());
        return byteToRead;
    }

    boolean hasMoreParts() {
        return this.hasMoreParts;
    }

    String getBoundaryMarker() {
        return this.boundaryMarker;
    }

    String getBoundaryEndMarker() {
        return this.boundaryEndMarker;
    }

    FIFOByteBuffer getFifoBuffer() {
        return this.fifoBuffer;
    }
}

