/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.builder;

import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.MimePartInputStream;
import com.mulesoft.connector.as2.internal.mime.builder.MimePartBuilder;
import com.mulesoft.connector.as2.internal.stream.OutputTransformationInputStream;
import java.io.IOException;
import org.bouncycastle.cms.CMSCompressedDataStreamGenerator;
import org.bouncycastle.cms.jcajce.ZlibCompressor;
import org.bouncycastle.operator.OutputCompressor;

public class CompressedMimePartBuilder
extends MimePartBuilder {
    private static final String SMIME_COMPRESSED_MESSAGE = "S/MIME Compressed Message";
    private static final String NOT_ABLE_TO_COMPRESS_MIME_PART = "not able to compress mimepart";
    private MimePart mimePart;

    public CompressedMimePartBuilder withMimePart(MimePart mimePart) {
        this.mimePart = mimePart;
        return this;
    }

    @Override
    public MimePart build() {
        MimePart compressedMimePart = new MimePart();
        this.headers.setContentType("application/pkcs7-mime; smime-type=compressed-data; name=\"smime.p7z\"");
        this.headers.setContentDisposition("attachment; filename=\"smime.p7z\"");
        this.headers.setContentDescription(SMIME_COMPRESSED_MESSAGE);
        compressedMimePart.setHeaders(this.headers);
        try {
            MimePartInputStream mimePartInputStream = new MimePartInputStream(this.mimePart);
            CMSCompressedDataStreamGenerator cmsCompressedDataStreamGenerator = new CMSCompressedDataStreamGenerator();
            compressedMimePart.setContent(new OutputTransformationInputStream(mimePartInputStream, outputStream -> cmsCompressedDataStreamGenerator.open(outputStream, (OutputCompressor)new ZlibCompressor())));
        }
        catch (IOException e) {
            throw new AS2ExtensionException(NOT_ABLE_TO_COMPRESS_MIME_PART);
        }
        return compressedMimePart;
    }
}

