/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.codec;

import com.mulesoft.connector.as2.internal.codec.Encoding;
import com.mulesoft.connector.as2.internal.stream.Buffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.Base64;

public class MimeBase64Encoding
extends Encoding {
    static final byte[] CRLF = "\r\n".getBytes();
    static final int MIME_MAX_LINE_LENGTH = 76;
    static final int TOTAL_ENCODED_LINE_LENGTH = 76 + CRLF.length;
    static final int UNENCODED_MAX_LINE_LENGTH = 57;
    private static final char[] toBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    @Override
    public byte[] encode(PushbackInputStream inputStream) throws IOException {
        Buffer encodedBuffer = new Buffer(TOTAL_ENCODED_LINE_LENGTH);
        byte[] bytesIn = new byte[57];
        int bytesread = this.readUntilByteArrayIsFull(bytesIn, inputStream);
        if (bytesread > 0) {
            Buffer unencodedBuffer = new Buffer(57);
            unencodedBuffer.load(bytesIn, 0, bytesread);
            while (unencodedBuffer.hasMoreData()) {
                bytesread = unencodedBuffer.read(bytesIn, 0, 3);
                if (bytesread == 3) {
                    int bits = (bytesIn[0] & 0xFF) << 16 | (bytesIn[1] & 0xFF) << 8 | bytesIn[2] & 0xFF;
                    encodedBuffer.load((byte)toBase64[bits >>> 18 & 0x3F]);
                    encodedBuffer.load((byte)toBase64[bits >>> 12 & 0x3F]);
                    encodedBuffer.load((byte)toBase64[bits >>> 6 & 0x3F]);
                    encodedBuffer.load((byte)toBase64[bits & 0x3F]);
                    if (encodedBuffer.available() < 76) continue;
                    encodedBuffer.load(CRLF);
                    continue;
                }
                int byteIn0 = bytesIn[0] & 0xFF;
                encodedBuffer.load((byte)toBase64[byteIn0 >> 2]);
                if (bytesread == 1) {
                    encodedBuffer.load((byte)toBase64[byteIn0 << 4 & 0x3F]);
                    encodedBuffer.load((byte)61);
                    encodedBuffer.load((byte)61);
                    continue;
                }
                if (bytesread != 2) continue;
                int byteIn1 = bytesIn[1] & 0xFF;
                encodedBuffer.load((byte)toBase64[byteIn0 << 4 & 0x3F | byteIn1 >> 4]);
                encodedBuffer.load((byte)toBase64[byteIn1 << 2 & 0x3F]);
                encodedBuffer.load((byte)61);
            }
        }
        return encodedBuffer.readAll();
    }

    @Override
    public byte[] decode(PushbackInputStream inputStream) throws IOException {
        byte[] encodedLine = new byte[TOTAL_ENCODED_LINE_LENGTH];
        int bytesread = this.readUntilEndOfLine(encodedLine, inputStream);
        if (bytesread <= 0) {
            return new byte[0];
        }
        encodedLine = bytesread < encodedLine.length ? Arrays.copyOf(encodedLine, bytesread) : Arrays.copyOf(encodedLine, 76);
        return Base64.getMimeDecoder().decode(encodedLine);
    }

    private int readUntilEndOfLine(byte[] bytes, InputStream in) throws IOException {
        int bytesread;
        for (bytesread = 0; bytesread < bytes.length; ++bytesread) {
            int b = in.read();
            if (b == -1) {
                return bytesread;
            }
            bytes[bytesread] = (byte)b;
            if (bytesread <= 0 || bytes[bytesread - 1] != 13 || b != 10) continue;
            return bytesread;
        }
        return bytesread;
    }

    @Override
    public byte[] decode(String encoded) {
        return Base64.getMimeDecoder().decode(encoded);
    }

    int readUntilByteArrayIsFull(byte[] bytes, InputStream in) throws IOException {
        int bytesread = in.read(bytes);
        if (bytesread == bytes.length || bytesread == -1) {
            return bytesread;
        }
        while (bytesread < bytes.length) {
            int b = in.read();
            if (b < 0) {
                return bytesread;
            }
            bytes[bytesread] = (byte)b;
            ++bytesread;
        }
        return bytesread;
    }
}

