/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.parse;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class FIFOByteBuffer {
    private int[] bytes;
    private boolean bufferEmpty = true;

    public FIFOByteBuffer(int length) {
        this.bytes = new int[length];
    }

    public int fillFifoBuffer(InputStream inputStream) throws IOException {
        byte[] bytesToFill = new byte[this.bytes.length];
        int i = inputStream.read(bytesToFill);
        for (int c = 0; c < bytesToFill.length; ++c) {
            this.bytes[c] = bytesToFill[c] & 0xFF;
        }
        this.bufferEmpty = false;
        return i;
    }

    public int pushPull(int byteToPush) {
        int byteToPull = this.bytes[0];
        int bufferSize = this.bytes.length;
        for (int position = 0; position != bufferSize - 1; ++position) {
            this.bytes[position] = this.bytes[position + 1];
        }
        this.bytes[bufferSize - 1] = byteToPush;
        return byteToPull;
    }

    public byte[] getBytes() {
        int i;
        byte[] bytesInBuffer = new byte[this.bytes.length];
        for (i = 0; i < this.bytes.length && this.bytes[i] != -1; ++i) {
            bytesInBuffer[i] = (byte)this.bytes[i];
        }
        if (i != this.bytes.length) {
            return Arrays.copyOf(bytesInBuffer, i);
        }
        return bytesInBuffer;
    }

    public boolean isBufferEmpty() {
        return this.bufferEmpty;
    }

    public int size() {
        return this.bytes.length;
    }
}

