/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.validate;

import com.mulesoft.connector.as2.internal.crypto.AS2Digest;
import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.mime.MDNReport;
import com.mulesoft.connector.as2.internal.mime.validate.MimePartValidator;
import java.util.Arrays;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDNReportValidator
implements MimePartValidator<MDNReport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MDNReportValidator.class);
    private AS2Digest digest;
    private AS2Digest alternativeDigest;

    public MDNReportValidator withDigest(AS2Digest digest) {
        this.digest = digest;
        return this;
    }

    public MDNReportValidator withAlternativeDigest(AS2Digest alternativeDigest) {
        this.alternativeDigest = alternativeDigest;
        return this;
    }

    @Override
    public boolean canValidate(String contentType) {
        return contentType != null && contentType.toLowerCase().startsWith("message/disposition-notification");
    }

    @Override
    public void validate(MDNReport mdnReportMimePart) {
        if (this.digest != null && mdnReportMimePart.getDecodedReceivedContentMIC() != null) {
            if (mdnReportMimePart.getDigestAlgorithm() != this.digest.getAlgorithm()) {
                throw new AS2ExtensionException(String.format("The digest algorithm requested %s does not match the digest algorithm received %s", new Object[]{this.digest.getAlgorithm(), mdnReportMimePart.getDigestAlgorithm()}), AS2ErrorType.SIGNATURE_VERIFY);
            }
            if (!Arrays.equals(mdnReportMimePart.getDecodedReceivedContentMIC(), this.digest.getHash())) {
                if (this.alternativeDigest != null && Arrays.equals(mdnReportMimePart.getDecodedReceivedContentMIC(), this.alternativeDigest.getHash())) {
                    LOGGER.info("Using alternative digest");
                    return;
                }
                throw new AS2ExtensionException(String.format("The digest of the content sent differs from the digest calculated by partner:\r\n%s\r\n%s\r\n", Base64.getMimeEncoder().encodeToString(this.digest.getHash()), mdnReportMimePart.getReceivedContentMic()), AS2ErrorType.SIGNATURE_VERIFY);
            }
        }
    }
}

