/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.builder;

import com.mulesoft.connector.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connector.as2.internal.error.DispositionType;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.builder.MimePartBuilder;
import java.io.ByteArrayInputStream;
import java.util.Base64;

public class MDNMimePartBuilder
extends MimePartBuilder {
    private static final String SEVEN_BIT = "7bit";
    private static final String REPORTING_UA_MULE4_AS2 = "Reporting-UA: Mulesoft AS2 connector\r\n";
    private static final String RFC_822 = "rfc822;";
    private static final String RECEIVED_CONTENT_MIC = "Received-Content-MIC";
    private static final String ORIGINAL_RECIPIENT = "Original-Recipient";
    private static final String FINAL_RECIPIENT = "Final-Recipient";
    private static final String ORIGINAL_MESSAGE_ID = "Original-Message-ID";
    private static final String DISPOSITION = "Disposition";
    private byte[] digest;
    private String originalRecipient;
    private String finalRecipient;
    private String messageId;
    private HashAlgorithm digestAlgorithm;
    private DispositionType dispositionType;

    public MDNMimePartBuilder withOriginalRecipient(String originalRecipient) {
        this.originalRecipient = originalRecipient;
        return this;
    }

    public MDNMimePartBuilder withFinalRecipient(String finalRecipient) {
        this.finalRecipient = finalRecipient;
        return this;
    }

    public MDNMimePartBuilder withMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public MDNMimePartBuilder withDigest(byte[] digest) {
        this.digest = digest;
        return this;
    }

    public MDNMimePartBuilder withDigestAlgorithm(HashAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        return this;
    }

    public MDNMimePartBuilder withDispositionType(DispositionType dispositionType) {
        this.dispositionType = dispositionType;
        return this;
    }

    @Override
    public MimePart build() {
        MimePart mimePart = new MimePart();
        this.headers.put("Content-Type", "message/disposition-notification");
        this.headers.put("Content-Transfer-Encoding", SEVEN_BIT);
        mimePart.setHeaders(this.headers);
        String receivedContentMic = "";
        if (this.digest != null && this.digestAlgorithm != null) {
            receivedContentMic = "Received-Content-MIC: " + Base64.getEncoder().encodeToString(this.digest) + ", " + (Object)((Object)this.digestAlgorithm) + "\r\n";
        }
        if (this.dispositionType == null) {
            this.dispositionType = DispositionType.PROCESSED;
        }
        String statusModifierDescription = "";
        statusModifierDescription = this.dispositionType != DispositionType.PROCESSED ? this.dispositionType.getStatus() + "/" + this.dispositionType.getStatusModifier() + ": " + this.dispositionType.getStatusDescription() : this.dispositionType.getStatus();
        String mdnContent = "Reporting-UA: Mulesoft AS2 connector\r\nOriginal-Recipient: rfc822; " + this.originalRecipient + "\r\n" + FINAL_RECIPIENT + ": " + RFC_822 + " " + this.finalRecipient + "\r\n" + ORIGINAL_MESSAGE_ID + ": " + this.messageId + "\r\n" + DISPOSITION + ": automatic-action/MDN-sent-automatically; " + statusModifierDescription + "\r\n" + receivedContentMic + "\r\n";
        this.content = new ByteArrayInputStream(mdnContent.getBytes());
        mimePart.setContent(this.content);
        return mimePart;
    }
}

