/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.builder;

import com.mulesoft.connector.as2.internal.codec.CodecInputStream;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.builder.MimePartBuilder;
import java.io.ByteArrayInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentMimePartBuilder
extends MimePartBuilder {
    private static final String TEXT_PLAIN_CHARSET_US_ASCII = "text/plain; charset=us-ascii";
    private String defaultDisposition;
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentMimePartBuilder.class);

    public ContentMimePartBuilder withDefaultDisposition() {
        this.defaultDisposition = "Attachment";
        return this;
    }

    @Override
    public MimePart build() {
        LOGGER.debug("Building Content MimePart...");
        MimePart mimePart = new MimePart();
        if (this.headers.getContentType() == null) {
            this.headers.setContentType(TEXT_PLAIN_CHARSET_US_ASCII);
        }
        if (this.content == null) {
            this.content = new ByteArrayInputStream(new byte[0]);
        }
        mimePart.setContent(CodecInputStream.builder(this.content, false).withEncoding(this.headers.getContentTransferEncoding()).build());
        if (this.headers.getContentDisposition() == null && this.defaultDisposition != null) {
            this.headers.setContentDisposition(this.defaultDisposition);
        }
        mimePart.setHeaders(this.headers);
        return mimePart;
    }
}

