/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.stream;

import com.mulesoft.connector.as2.internal.crypto.AS2Digest;
import com.mulesoft.connector.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.stream.As2File;
import com.mulesoft.connector.as2.internal.utils.AS2Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.mule.runtime.api.streaming.bytes.ImmutableFileRepeatableInputStream;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InputStreamResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputStreamResource.class);

    public static InputStreamResource saveToResource(InputStream inputStream) {
        try {
            AS2Utils.logInputStream(inputStream, "InputStreamResource/saveToResource()", LOGGER);
            return new CachedInputStreamResource(inputStream, false, null);
        }
        catch (IOException e) {
            LOGGER.error("Failed to Cache an Input Stream.", (Throwable)e);
            throw new AS2ExtensionException("Failed to Cache an Input Stream.", e);
        }
    }

    public static InputStreamResource saveToResource(InputStream inputStream, boolean checkSign, HashAlgorithm algorithm) {
        try {
            AS2Utils.logInputStream(inputStream, "InputStreamResource/saveToResource()", LOGGER);
            return new CachedInputStreamResource(inputStream, checkSign, algorithm);
        }
        catch (IOException e) {
            LOGGER.error("Failed to Cache an Input Stream.", (Throwable)e);
            throw new AS2ExtensionException("Failed to Cache an Input Stream.", e);
        }
    }

    public abstract void clearResource();

    public abstract InputStream asInputStream();

    public static class CachedInputStreamResource
    extends InputStreamResource {
        private static final String PROPERTY_BASE_PATH = "com.mulesoft.connector.as2.";
        private static final File TEMP_FILE_DIR;
        private static final int KB = 1024;
        private static final int DEFAULT_THRESHOLD = 65536;
        private static final int THRESHOLD;
        private File fileResource;
        private byte[] arrayResource;
        private AS2Digest as2DigestForSign;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CachedInputStreamResource(InputStream inputstream, boolean checkSign, HashAlgorithm algorithm) throws IOException {
            block17: {
                InputStream is = inputstream;
                LOGGER.debug("Start CachedInputStreamResource.");
                AS2Utils.logInputStream(is, "CachedInputStreamResource/constructor()", LOGGER);
                if (checkSign) {
                    this.as2DigestForSign = new AS2Digest().withContent(inputstream).withAlgorithm(algorithm).initialise();
                    is = this.as2DigestForSign.getDigestingInputStream();
                }
                try {
                    if (THRESHOLD == -1) {
                        this.arrayResource = IOUtils.toByteArray((InputStream)is);
                        break block17;
                    }
                    this.arrayResource = new byte[THRESHOLD];
                    int pos = 0;
                    int i = is.read();
                    while (i != -1 && pos < THRESHOLD) {
                        this.arrayResource[pos++] = (byte)i;
                        i = is.read();
                    }
                    if (i != -1) {
                        File tempFile;
                        if (TEMP_FILE_DIR == null) {
                            tempFile = File.createTempFile("as2", "tmp");
                            LOGGER.debug("Custom Temp file created.");
                        } else {
                            tempFile = File.createTempFile("as2", "tmp", TEMP_FILE_DIR);
                            LOGGER.debug("Default Temp file created.");
                        }
                        tempFile.deleteOnExit();
                        FileOutputStream os = new FileOutputStream(tempFile);
                        try {
                            IOUtils.copyLarge((InputStream)new ByteArrayInputStream(this.arrayResource), (OutputStream)os);
                            os.write(i);
                            IOUtils.copyLarge((InputStream)is, (OutputStream)os);
                            LOGGER.debug("Input stream writed into tempFile.");
                        }
                        finally {
                            try {
                                os.close();
                            }
                            finally {
                                this.arrayResource = null;
                            }
                        }
                        this.fileResource = new As2File(tempFile, this);
                        break block17;
                    }
                    this.arrayResource = Arrays.copyOf(this.arrayResource, pos);
                }
                finally {
                    is.close();
                }
            }
        }

        @Override
        public void clearResource() {
            if (this.fileResource != null && this.fileResource.exists()) {
                String absolutePath = this.fileResource.getAbsolutePath();
                if (!this.fileResource.delete()) {
                    LOGGER.warn("Failed to delete the input stream resource: {}", (Object)absolutePath);
                } else {
                    LOGGER.debug("Cleared the saved input stream resource from disk at: {}", (Object)absolutePath);
                }
            }
            if (this.arrayResource != null && this.arrayResource.length > 0) {
                this.arrayResource = null;
                LOGGER.debug("Cleared the saved input stream resource from memory.");
            }
        }

        public AS2Digest getAs2DigestForSign() {
            return this.as2DigestForSign;
        }

        @Override
        public InputStream asInputStream() {
            if (this.arrayResource != null) {
                return new ByteArrayInputStream(this.arrayResource);
            }
            if (this.fileResource != null) {
                return new ImmutableFileRepeatableInputStream(this.fileResource, false);
            }
            return null;
        }

        static {
            File f;
            String s = System.getProperty("com.mulesoft.connector.as2.CachedOutputStream.OutputDirectory");
            TEMP_FILE_DIR = s != null ? ((f = new File(s)).exists() && f.isDirectory() ? f : null) : null;
            String v = System.getProperty("com.mulesoft.connector.as2.CachedOutputStream.Threshold");
            THRESHOLD = v == null ? 65536 : Integer.parseInt(v) * 1024;
            File tmpDirectory = TEMP_FILE_DIR == null ? new File(System.getProperty("java.io.tmpdir")) : TEMP_FILE_DIR;
            String[] tmpFiles = tmpDirectory.list();
            if (tmpFiles != null) {
                for (String tmpFileName : tmpFiles) {
                    File tmpFile = new File(tmpDirectory, tmpFileName);
                    if (!tmpFile.isFile() || !tmpFile.getName().matches("^as2.*tmp$")) continue;
                    tmpFile.delete();
                }
            }
        }
    }
}

