/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.stream;

import com.mulesoft.connector.as2.internal.stream.BufferLoadingInputStream;
import com.mulesoft.connector.as2.internal.stream.OutputStreamWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputTransformationInputStream
extends BufferLoadingInputStream {
    private OutputStream transformingOutputStream;
    private static final Logger LOGGER = LoggerFactory.getLogger(OutputTransformationInputStream.class);

    public OutputTransformationInputStream(InputStream data, OutputStreamWrapper wrapper) throws IOException {
        super(data);
        this.transformingOutputStream = wrapper.wrap(new BufferOutputStream());
    }

    @Override
    public void loadBuffer(byte b) throws IOException {
        this.transformingOutputStream.write(b);
        LOGGER.debug(String.format("OutputStream values: %s", this.transformingOutputStream));
    }

    @Override
    protected void loadBuffer(byte[] b, int offset, int length) throws IOException {
        this.transformingOutputStream.write(b, offset, length);
        LOGGER.debug(String.format("OutputStream values: %s", this.transformingOutputStream));
    }

    @Override
    protected void endOfUnderlyingStream() throws IOException {
        this.transformingOutputStream.close();
        LOGGER.debug("OutputStream was closed.");
    }

    private class BufferOutputStream
    extends OutputStream {
        private BufferOutputStream() {
        }

        @Override
        public void write(int b) {
            OutputTransformationInputStream.this.buffer.load((byte)b);
            LOGGER.debug(String.format("Buffer values: %s", OutputTransformationInputStream.this.buffer));
        }

        @Override
        public void write(byte[] b) {
            OutputTransformationInputStream.this.buffer.load(b);
            LOGGER.debug(String.format("Buffer values: %s", OutputTransformationInputStream.this.buffer));
        }

        @Override
        public void write(byte[] b, int off, int len) {
            OutputTransformationInputStream.this.buffer.load(b, off, len);
            LOGGER.debug(String.format("Buffer values: %s", OutputTransformationInputStream.this.buffer));
        }
    }
}

