/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.stream;

import com.mulesoft.connector.as2.internal.stream.Buffer;
import com.mulesoft.connector.as2.internal.utils.AS2Utils;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplayInputStream
extends FilterInputStream {
    private Buffer buffer = new Buffer(1024);
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplayInputStream.class);

    public ReplayInputStream(InputStream in) {
        super(in);
        AS2Utils.logInputStream(in, "ReplayInputStream/constructor()", LOGGER);
    }

    @Override
    public int read() throws IOException {
        int val = super.read();
        if (val != -1) {
            this.buffer.load((byte)val);
            LOGGER.debug(String.format("Buffer values: %s", this.buffer));
        }
        return val;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int length) throws IOException {
        int val = super.read(b, off, length);
        this.buffer.load(b, off, length);
        LOGGER.debug(String.format("Buffer values: %s", this.buffer));
        return val;
    }

    public byte[] replay() {
        return this.buffer.readAll();
    }
}

