/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.crypto;

import com.mulesoft.connector.as2.internal.crypto.PKCS7SignatureBlock;
import com.mulesoft.connector.as2.internal.enums.HashAlgorithm;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PKCS7SignatureBlockBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PKCS7SignatureBlockBuilder.class);
    private List<Certificate> certificates = new ArrayList<Certificate>();
    private List<byte[]> encryptedHashes = new ArrayList<byte[]>();
    private List<HashAlgorithm> hashAlgorithms = new ArrayList<HashAlgorithm>();

    PKCS7SignatureBlockBuilder() {
    }

    public PKCS7SignatureBlockBuilder withCertificate(Certificate certificate) {
        this.certificates.add(certificate);
        return this;
    }

    public PKCS7SignatureBlockBuilder withEncryptedHash(byte[] encryptedHash) {
        this.encryptedHashes.add(encryptedHash);
        return this;
    }

    public PKCS7SignatureBlockBuilder withHashAlgorithm(HashAlgorithm algorithm) {
        this.hashAlgorithms.add(algorithm);
        return this;
    }

    public PKCS7SignatureBlock build() {
        LOGGER.debug("Building PKCS7 Signature Block");
        PKCS7SignatureBlock pkcs7SignatureBlock = new PKCS7SignatureBlock();
        pkcs7SignatureBlock.setCertificates(this.certificates);
        pkcs7SignatureBlock.setEncryptedHashes(this.encryptedHashes);
        pkcs7SignatureBlock.setHashAlgorithms(this.hashAlgorithms);
        LOGGER.debug("Finished Built PKCS7 Signature Block");
        return pkcs7SignatureBlock;
    }
}

