/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.stream;

import com.mulesoft.connector.as2.internal.stream.Buffer;
import com.mulesoft.connector.as2.internal.utils.AS2Utils;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BufferLoadingInputStream
extends InputStream {
    private InputStream wrappedInputStream;
    private boolean closed;
    private boolean moreDataAvailable = true;
    protected Buffer buffer = new Buffer(1024);
    private static final Logger LOGGER = LoggerFactory.getLogger(BufferLoadingInputStream.class);

    protected BufferLoadingInputStream(InputStream in) {
        AS2Utils.logInputStream(in, "BufferLoadingInputStream", LOGGER);
        this.wrappedInputStream = in;
    }

    protected abstract void loadBuffer(byte var1) throws IOException;

    protected abstract void loadBuffer(byte[] var1, int var2, int var3) throws IOException;

    protected abstract void endOfUnderlyingStream() throws IOException;

    @Override
    public int read() throws IOException {
        if (this.closed) {
            LOGGER.error("BufferLoadingInputStream is closed");
            throw new IOException("Stream is closed");
        }
        AS2Utils.logInputStream(this.wrappedInputStream, "BufferLoadingInputStream/read()", LOGGER);
        while (this.moreDataAvailable && !this.buffer.hasMoreData()) {
            int val = this.wrappedInputStream.read();
            if (val == -1) {
                this.moreDataAvailable = false;
                this.endOfUnderlyingStream();
                continue;
            }
            this.loadBuffer((byte)val);
        }
        return this.buffer.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int length) throws IOException {
        if (this.closed) {
            LOGGER.error("BufferLoadingInputStream is closed");
            throw new IOException("Stream is closed");
        }
        AS2Utils.logInputStream(this.wrappedInputStream, "BufferLoadingInputStream/read(byte, int, int)", LOGGER);
        while (this.moreDataAvailable && this.buffer.available() < length) {
            int bytesRead = this.wrappedInputStream.read(b, off, length - this.buffer.available());
            if (bytesRead == -1) {
                this.moreDataAvailable = false;
                this.endOfUnderlyingStream();
                continue;
            }
            this.loadBuffer(b, off, bytesRead);
        }
        return this.buffer.read(b, off, length);
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.wrappedInputStream.close();
            LOGGER.debug("Wrapped input stream was closed.");
        }
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            LOGGER.error("BufferLoadingInputStream is closed");
            throw new IOException("Stream is closed");
        }
        return this.wrappedInputStream.available() + this.buffer.available();
    }
}

