/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.parse;

import com.mulesoft.connector.as2.internal.codec.CodecInputStream;
import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.DispositionType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.mime.MimeHeaders;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.parse.MimeContentParser;
import com.mulesoft.connector.as2.internal.mime.parse.MimeParserController;
import com.mulesoft.connector.as2.internal.utils.AS2PatternMatchers;
import com.mulesoft.connector.as2.internal.utils.AS2Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.cms.CMSCompressedDataParser;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.jcajce.ZlibExpanderProvider;
import org.bouncycastle.operator.InputExpanderProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionMimeParser
implements MimeContentParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressionMimeParser.class);
    private static final String COMPRESSED_DATE = "compressed-data";
    private static final String APPLICATION_PKCS7_MIME = "application/pkcs7-mime";
    private static final String UNABLE_TO_DECOMPRESS_RECEIVED_MESSAGE = "unable to decompress received message";

    @Override
    public boolean canParseContentType(String contentType) {
        if (contentType == null) {
            LOGGER.warn("ContentTypeValue is null!");
            return false;
        }
        String sMimeType = AS2PatternMatchers.findSMimeTypeFrom(contentType);
        if (contentType.toLowerCase().startsWith(APPLICATION_PKCS7_MIME) && sMimeType != null) {
            LOGGER.debug("Can parse COMPRESSED_DATE.");
            return sMimeType.equalsIgnoreCase(COMPRESSED_DATE);
        }
        LOGGER.debug("ContentTypeValue couldn't be parsed.");
        return false;
    }

    @Override
    public boolean digestRequired() {
        return false;
    }

    public MimePart parse(MimeHeaders mimeHeaders, InputStream is, MimeParserController mimeParserController) {
        LOGGER.debug("Parsing compressed MIME part.");
        is = this.getDecodedInputStream(mimeHeaders, is);
        try {
            CMSCompressedDataParser compressedDataParser = new CMSCompressedDataParser(is);
            CMSTypedStream cmsStream = compressedDataParser.getContent((InputExpanderProvider)new ZlibExpanderProvider());
            MimePart underlyingMimePart = mimeParserController.parse(cmsStream.getContentStream());
            while (is.read() != -1) {
            }
            LOGGER.debug("Finished parsing compressed MIME part.");
            return underlyingMimePart;
        }
        catch (IOException | CMSException e) {
            throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_DECOMPRESSION_FAILED, UNABLE_TO_DECOMPRESS_RECEIVED_MESSAGE, AS2ErrorType.INFLATE, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getDecodedInputStream(MimeHeaders mimeHeaders, InputStream is) {
        if (LOGGER.isTraceEnabled()) {
            ByteArrayOutputStream in1 = null;
            try {
                in1 = AS2Utils.logInputStream(is, "CodecInputStreamBuilder/builder() - From CompressionMimeParser", LOGGER);
                is = new ByteArrayInputStream(in1.toByteArray());
            }
            finally {
                AS2Utils.closeOutStream(in1, LOGGER);
            }
        }
        return CodecInputStream.builder(is, true).withEncoding(mimeHeaders.getContentTransferEncoding()).build();
    }
}

