/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.parse;

import com.mulesoft.connector.as2.internal.codec.CodecInputStream;
import com.mulesoft.connector.as2.internal.mime.MimeHeaders;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.parse.MimeContentParser;
import com.mulesoft.connector.as2.internal.mime.parse.MimeParserController;
import com.mulesoft.connector.as2.internal.stream.InputStreamResource;
import com.mulesoft.connector.as2.internal.utils.AS2Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMimeContentParser
implements MimeContentParser<MimePart> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleMimeContentParser.class);

    @Override
    public boolean canParseContentType(String contentType) {
        return true;
    }

    @Override
    public boolean digestRequired() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MimePart parse(MimeHeaders mimeHeaders, InputStream is, MimeParserController mimeParserController) {
        LOGGER.debug("Parsing simple MIME content");
        MimePart mimePart = new MimePart();
        mimePart.setHeaders(mimeHeaders);
        LOGGER.debug("Starting build Encoding for Simple Mime Content");
        if (LOGGER.isTraceEnabled()) {
            ByteArrayOutputStream in1 = null;
            try {
                in1 = AS2Utils.logInputStream(is, "CodecInputStreamBuilder/builder() - From SimpleMimeContentParser", LOGGER);
                is = new ByteArrayInputStream(in1.toByteArray());
            }
            finally {
                AS2Utils.closeOutStream(in1, LOGGER);
            }
        }
        InputStream decodedStream = CodecInputStream.builder(is, true).withEncoding(mimeHeaders.getContentTransferEncoding()).build();
        InputStreamResource inputStreamResource = InputStreamResource.saveToResource(decodedStream);
        mimePart.setInputResource(inputStreamResource);
        LOGGER.debug("Finished parsing simple MIME content");
        return mimePart;
    }
}

