/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.utils;

import com.mulesoft.connector.as2.internal.error.DispositionType;
import com.mulesoft.connector.as2.internal.mime.MDNReport;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class AS2Utils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream logInputStream(InputStream in, String classOrMethodName, Logger logger) {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayInputStream is1 = null;
        try {
            ByteArrayOutputStream outputStream = AS2Utils.getByteArrayOutputStream(in);
            is1 = new ByteArrayInputStream(outputStream.toByteArray());
            String inputStreamValue = new BufferedReader(new InputStreamReader((InputStream)is1, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            logger.trace(String.format("The value of the InputStream inside %s is: %s", classOrMethodName, inputStreamValue));
            byteArrayOutputStream = outputStream;
        }
        catch (Exception e) {
            ByteArrayOutputStream byteArrayOutputStream2;
            try {
                logger.warn("Error trying to read InputStream value!", (Throwable)e);
                byteArrayOutputStream2 = null;
            }
            catch (Throwable throwable) {
                AS2Utils.closeInputStream(is1, logger);
                throw throwable;
            }
            AS2Utils.closeInputStream(is1, logger);
            return byteArrayOutputStream2;
        }
        AS2Utils.closeInputStream(is1, logger);
        return byteArrayOutputStream;
    }

    private static ByteArrayOutputStream getByteArrayOutputStream(InputStream input) throws IOException {
        int len;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = input.read(buffer)) > -1) {
            byteArrayOutputStream.write(buffer, 0, len);
        }
        byteArrayOutputStream.flush();
        return byteArrayOutputStream;
    }

    private static void closeInputStream(InputStream in, Logger logger) {
        try {
            in.close();
        }
        catch (IOException e) {
            logger.warn("Error trying to close InputStream value!", (Throwable)e);
        }
    }

    public static void closeOutStream(OutputStream in, Logger logger) {
        try {
            in.close();
        }
        catch (IOException e) {
            logger.warn("Error trying to close OutputStream value!", (Throwable)e);
        }
    }

    public static String getProcessedCodeFromMDNReport(MDNReport report) {
        String processedStatus;
        String processedValue = DispositionType.PROCESSED.getStatus();
        if (report.getDispositionNotificationContent() != null && report.getDispositionNotificationContent().get((Object)"Disposition") != null && !(processedStatus = ((String)((List)report.getDispositionNotificationContent().get((Object)"Disposition")).get(1)).trim()).endsWith(processedValue)) {
            processedValue = processedStatus.split(":")[1].trim();
        }
        return processedValue;
    }
}

