/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.builder;

import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.MimePartInputStream;
import com.mulesoft.connector.as2.internal.mime.builder.BoundaryIdentifierGeneratorFactory;
import com.mulesoft.connector.as2.internal.mime.builder.MimePartBuilder;
import com.mulesoft.connector.as2.internal.utils.AS2Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeMultipartBuilder
extends MimePartBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimeMultipartBuilder.class);
    static final String BOUNDARY_MARKER = "--";
    static final String CRLF = "\r\n";
    List<MimePart> mimeParts = new ArrayList<MimePart>();
    String boundaryIdentifier;
    String boundary;
    String boundaryEnd;
    BoundaryIdentifierGeneratorFactory boundaryIdentifierGeneratorFactory = new BoundaryIdentifierGeneratorFactory();

    public MimeMultipartBuilder withBoundaryIdentifierGeneratorFactory(BoundaryIdentifierGeneratorFactory boundaryIdentifierGeneratorFactory) {
        this.boundaryIdentifierGeneratorFactory = boundaryIdentifierGeneratorFactory;
        return this;
    }

    public MimeMultipartBuilder withMimePart(MimePart mimePart) {
        if (mimePart != null) {
            this.mimeParts.add(mimePart);
        }
        return this;
    }

    @Override
    public MimePart build() {
        LOGGER.trace("Building Mime Multipart");
        MimePart multipart = new MimePart();
        this.boundaryIdentifier = this.boundaryIdentifierGeneratorFactory.getInstance().generateBoundaryIdentifier();
        this.boundary = "\r\n--" + this.boundaryIdentifier + CRLF;
        this.boundaryEnd = "\r\n--" + this.boundaryIdentifier + BOUNDARY_MARKER + CRLF;
        this.content = this.composeContent();
        this.headers.setContentType(String.format("%s; boundary=\"%s\"", this.headers.getContentType(), this.boundaryIdentifier));
        LOGGER.debug(String.format("Mime Multipart ContentType is %s", this.headers.getContentType()));
        multipart.setBoundaryIdentifier(this.boundaryIdentifier);
        multipart.setMimeParts(this.mimeParts);
        multipart.setHeaders(this.headers);
        multipart.setContent(this.content);
        return multipart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream composeContent() {
        Vector<InputStream> allTheStreams = new Vector<InputStream>();
        for (MimePart mimePart : this.mimeParts) {
            allTheStreams.add(new ByteArrayInputStream(this.boundary.getBytes()));
            allTheStreams.add(new MimePartInputStream(mimePart));
        }
        allTheStreams.add(new ByteArrayInputStream(this.boundaryEnd.getBytes()));
        InputStream composeContent = new SequenceInputStream(allTheStreams.elements());
        if (LOGGER.isTraceEnabled()) {
            ByteArrayOutputStream is1 = null;
            try {
                is1 = AS2Utils.logInputStream(composeContent, "MimeMultipartBuilder/build()", LOGGER);
                composeContent = new ByteArrayInputStream(is1.toByteArray());
            }
            finally {
                AS2Utils.closeOutStream(is1, LOGGER);
            }
        }
        return composeContent;
    }
}

