/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.builder;

import com.mulesoft.connector.as2.internal.codec.CodecInputStream;
import com.mulesoft.connector.as2.internal.crypto.PKCS7EncryptedEnvelopeStreamBuilder;
import com.mulesoft.connector.as2.internal.enums.EncodingType;
import com.mulesoft.connector.as2.internal.enums.EncryptionAlgorithm;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.MimePartInputStream;
import com.mulesoft.connector.as2.internal.mime.builder.MimePartBuilder;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedMimePartBuilder
extends MimePartBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptedMimePartBuilder.class);
    private MimePart mimePart;
    private X509Certificate certificate;
    private EncryptionAlgorithm encryptionAlgorithm;
    private boolean propagateContentType;

    public EncryptedMimePartBuilder withPropagateContentType(boolean propagateContentType) {
        this.propagateContentType = propagateContentType;
        return this;
    }

    @Override
    public EncryptedMimePartBuilder withContentTransferEncoding(EncodingType encoding) {
        if (this.propagateContentType) {
            super.withContentTransferEncoding(encoding);
        }
        return this;
    }

    public EncryptedMimePartBuilder withMimePart(MimePart mimePart) {
        this.mimePart = mimePart;
        return this;
    }

    public EncryptedMimePartBuilder withCertificate(X509Certificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public EncryptedMimePartBuilder withEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    @Override
    public MimePart build() {
        LOGGER.trace("Building Encrypted MimePart...");
        this.validateReadyToBuild();
        MimePart encryptedMimePart = new MimePart();
        this.headers.setContentType("application/pkcs7-mime; smime-type=enveloped-data; name=\"smime.p7m\"");
        this.headers.setContentDisposition("attachment; filename=\"smime.p7m\"");
        encryptedMimePart.setHeaders(this.headers);
        encryptedMimePart.setContent(CodecInputStream.builder(new PKCS7EncryptedEnvelopeStreamBuilder().withContent(new MimePartInputStream(this.mimePart)).withCertificate(this.certificate).withEncryptionAlgorithm(this.encryptionAlgorithm).build(), false).withEncoding(this.headers.getContentTransferEncoding()).build());
        LOGGER.trace("Finishing Encrypted MimePart...");
        return encryptedMimePart;
    }

    private void validateReadyToBuild() {
        if (this.mimePart == null) {
            throw new AS2ExtensionException("EncryptedMimePartBuilder must be initialised with a MimePart to encrypt");
        }
        if (this.certificate == null) {
            throw new AS2ExtensionException("EncryptedMimePartBuilder must be initialised with an X509Certificate before building");
        }
        if (this.encryptionAlgorithm == null) {
            throw new AS2ExtensionException("EncryptedMimePartBuilder must be initialised with an EncryptionAlgorithm before building");
        }
    }
}

