/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.parse;

import com.mulesoft.connector.as2.internal.codec.Encoding;
import com.mulesoft.connector.as2.internal.mime.MDNReport;
import com.mulesoft.connector.as2.internal.mime.MimeHeaders;
import com.mulesoft.connector.as2.internal.mime.parse.MimeContentParser;
import com.mulesoft.connector.as2.internal.mime.parse.MimeParserController;
import com.mulesoft.connector.as2.internal.utils.AS2PatternMatchers;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDNReportParser
implements MimeContentParser<MDNReport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MDNReportParser.class);

    @Override
    public boolean canParseContentType(String contentType) {
        return contentType != null && contentType.toLowerCase().startsWith("message/disposition-notification");
    }

    @Override
    public boolean digestRequired() {
        return false;
    }

    @Override
    public MDNReport parse(MimeHeaders mimeHeaders, InputStream is, MimeParserController mimeParserController) {
        LOGGER.trace("Starting MDNReportParser");
        String reportContent = this.extractDispositionNotification(mimeHeaders, IOUtils.toString((InputStream)is));
        MDNReport report = new MDNReport();
        report.setDispositionNotificationContent(this.getDispositionNotificationContent(reportContent));
        reportContent = "\r\n" + reportContent;
        report.setOriginalMessageId(AS2PatternMatchers.findOriginalMessageIdFrom(reportContent));
        report.setReceivedContentMic(AS2PatternMatchers.findReceivedContentMicFrom(reportContent));
        report.setDigestAlgorithm(AS2PatternMatchers.findReceivedContentMicAlgorithmFrom(reportContent));
        report.setProcessed(AS2PatternMatchers.findDisposition(reportContent));
        report.setOriginalRecipient(AS2PatternMatchers.findOriginalRecipient(reportContent));
        report.setFinalRecipient(AS2PatternMatchers.findFinalRecipient(reportContent));
        report.setHeaders(mimeHeaders);
        report.setReportText(reportContent);
        return report;
    }

    private MultiMap<String, List<String>> getDispositionNotificationContent(String reportContent) {
        String[] contentRows;
        MultiMap dispositionNotificationContent = new MultiMap();
        for (String row : contentRows = reportContent.split("\r\n")) {
            String[] rowParts = row.split(":", 2);
            String[] splitRowContent = rowParts[1].split("[;,]");
            List collection = Arrays.stream(splitRowContent).map(String::trim).collect(Collectors.toList());
            String key = rowParts[0].substring(0, 1).toUpperCase(Locale.ROOT) + rowParts[0].substring(1);
            dispositionNotificationContent.put((Object)key, collection);
        }
        return dispositionNotificationContent;
    }

    private String extractDispositionNotification(MimeHeaders mimeHeaders, String content) {
        LOGGER.trace("Extracting Disposition Notification.");
        if (mimeHeaders.getContentTransferEncoding() != null) {
            LOGGER.debug(String.format("Header Transfer Encoding value is: %s", new Object[]{mimeHeaders.getContentTransferEncoding()}));
            Encoding encodingType = Encoding.getEncodingForType(mimeHeaders.getContentTransferEncoding());
            if (encodingType != null) {
                LOGGER.debug("Decoding the message/disposition-notification from encoding {}", (Object)encodingType.toString());
                byte[] decode = encodingType.decode(content);
                return new String(decode);
            }
        }
        return content;
    }
}

