/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime;

import com.mulesoft.connector.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.MimePartFinder;
import java.util.Base64;
import java.util.List;
import org.mule.runtime.api.util.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDNReport
extends MimePart {
    private static final String MESSAGE_DISPOSITION_NOTIFICATION = "message/disposition-notification";
    private static final Logger logger = LoggerFactory.getLogger(MDNReport.class);
    private String originalRecipient;
    private String finalRecipient;
    private String originalMessageId;
    private String receivedContentMic;
    private String reportText;
    private boolean processed;
    private MultiMap<String, List<String>> dispositionNotificationContent;
    private HashAlgorithm digestAlgorithm;

    public static MDNReport findMDNReport(MimePart mimePart) {
        String contType = mimePart.getHeaders().getContentType();
        logger.trace("Entering the MDNReport.findMDNReport(mimePart)\nContent-Type from mimePart is '" + contType + "'");
        return (MDNReport)new MimePartFinder(mp -> mp.getHeaders().getContentType() != null && mp.getHeaders().getContentType().toLowerCase().startsWith(MESSAGE_DISPOSITION_NOTIFICATION)).find(mimePart);
    }

    public byte[] getDecodedReceivedContentMIC() {
        byte[] receivedContentMic;
        try {
            receivedContentMic = Base64.getMimeDecoder().decode(this.getReceivedContentMic());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return receivedContentMic;
    }

    public String getReceivedContentMic() {
        return this.receivedContentMic;
    }

    public void setDispositionNotificationContent(MultiMap<String, List<String>> dispositionNotificationContent) {
        this.dispositionNotificationContent = dispositionNotificationContent;
    }

    public MultiMap<String, List<String>> getDispositionNotificationContent() {
        return this.dispositionNotificationContent;
    }

    public void setReceivedContentMic(String receivedContentMic) {
        this.receivedContentMic = receivedContentMic;
    }

    public HashAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(HashAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public void setOriginalMessageId(String originalMessageId) {
        this.originalMessageId = originalMessageId;
    }

    public String getOriginalMessageId() {
        return this.originalMessageId;
    }

    public String getOriginalRecipient() {
        return this.originalRecipient;
    }

    public void setOriginalRecipient(String originalRecipient) {
        this.originalRecipient = originalRecipient;
    }

    public String getFinalRecipient() {
        return this.finalRecipient;
    }

    public void setFinalRecipient(String finalRecipient) {
        this.finalRecipient = finalRecipient;
    }

    public String getReportText() {
        return this.reportText;
    }

    public void setReportText(String reportText) {
        this.reportText = reportText;
    }
}

