/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.builder;

import com.mulesoft.connector.as2.internal.codec.CodecInputStream;
import com.mulesoft.connector.as2.internal.crypto.AS2Signature;
import com.mulesoft.connector.as2.internal.crypto.PKCS7SignatureBlockInputStream;
import com.mulesoft.connector.as2.internal.enums.EncodingType;
import com.mulesoft.connector.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.builder.MimePartBuilder;
import java.security.cert.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureMimePartBuilder
extends MimePartBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignatureMimePartBuilder.class);
    private AS2Signature signature;
    private Certificate certificate;
    private HashAlgorithm algorithm;
    private EncodingType encoding;
    private boolean propagateContentType;

    public SignatureMimePartBuilder withPropagateContentType(boolean propagateContentType) {
        this.propagateContentType = propagateContentType;
        return this;
    }

    @Override
    public SignatureMimePartBuilder withContentTransferEncoding(EncodingType encoding) {
        if (this.propagateContentType) {
            this.encoding = encoding;
            super.withContentTransferEncoding(encoding);
        } else {
            this.encoding = EncodingType.BASE64;
        }
        return this;
    }

    public SignatureMimePartBuilder withSignature(AS2Signature signature) {
        this.signature = signature;
        return this;
    }

    public SignatureMimePartBuilder withCertificate(Certificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public SignatureMimePartBuilder withAlgorithm(HashAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @Override
    public MimePart build() {
        LOGGER.trace("Building Signature MimePart...");
        MimePart mimePart = new MimePart();
        EncodingType encoding = this.encoding == null ? EncodingType.BASE64 : this.encoding;
        LOGGER.debug(String.format("encoding to use, into build Signature MimePart is %s:", new Object[]{encoding}));
        if (this.signature == null) {
            throw new AS2ExtensionException("SignatureMimePartBuilder.build() was called before being initialised with an AS2Signature!");
        }
        this.content = new PKCS7SignatureBlockInputStream().withCertificate(this.certificate).withSignature(this.signature).withHashAlgorithm(this.algorithm);
        mimePart.setContent(CodecInputStream.builder(this.content, false).withEncoding(encoding).build());
        this.headers.setContentType("application/pkcs7-signature; name=smime.p7s; smime-type=signed-data");
        this.headers.setContentTransferEncoding(encoding);
        mimePart.setHeaders(this.headers);
        LOGGER.trace("Finishing Signature MimePart Process...");
        return mimePart;
    }
}

