/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.send.headers;

import com.mulesoft.connector.as2.internal.send.headers.HeaderValidationRule;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpHeadersValueRule
implements HeaderValidationRule {
    @Override
    public boolean isValidHeader(Map.Entry<String, String> header) {
        String headerValue = header.getValue();
        Pattern pattern = Pattern.compile("^[\\x09\\x20-\\x7E\\x80-\\xFF]*$");
        Matcher matcher = pattern.matcher(headerValue);
        return matcher.find() && !this.containsCRLF(headerValue) && !this.startEndWithSpaceOrTab(headerValue);
    }

    @Override
    public String getWarningMessage(Map.Entry<String, String> header) {
        return String.format("The header '%s' with the value '%s' won't be added because it is not compliant with the RFC 7230", header.getKey(), header.getValue());
    }

    private boolean startEndWithSpaceOrTab(String text) {
        return text.startsWith(" ") || text.startsWith("\t") || text.endsWith(" ") || text.endsWith("\t");
    }

    private boolean containsCRLF(String text) {
        return text.contains("\n") || text.contains("\r");
    }
}

